/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.distributed.MatrixKeyMapper;
import org.apache.ignite.ml.math.distributed.ValueMapper;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.CacheMatrixStorage;

public class CacheMatrix<K, V>
extends AbstractMatrix {
    public CacheMatrix() {
    }

    public CacheMatrix(int rows, int cols, IgniteCache<K, V> cache, MatrixKeyMapper<K> keyMapper, ValueMapper<V> valMapper) {
        assert (rows > 0);
        assert (cols > 0);
        assert (cache != null);
        assert (keyMapper != null);
        assert (valMapper != null);
        this.setStorage(new CacheMatrixStorage<K, V>(rows, cols, cache, keyMapper, valMapper));
    }

    private CacheMatrixStorage<K, V> storage() {
        return (CacheMatrixStorage)this.getStorage();
    }

    @Override
    public Matrix copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix like(int rows, int cols) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector likeVector(int crd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix divide(double d) {
        return this.mapOverValues(v -> v / d);
    }

    @Override
    public Matrix plus(double x) {
        return this.mapOverValues(v -> v + x);
    }

    @Override
    public Matrix times(double x) {
        return this.mapOverValues(v -> v * x);
    }

    @Override
    public Matrix assign(double val) {
        return this.mapOverValues(v -> val);
    }

    @Override
    public Matrix map(IgniteDoubleFunction<Double> fun) {
        return this.mapOverValues(fun::apply);
    }

    @Override
    public double sum() {
        CacheMatrixStorage<K, V> sto = this.storage();
        return CacheUtils.sum(sto.cache().getName(), sto.keyMapper(), sto.valueMapper());
    }

    @Override
    public double maxValue() {
        CacheMatrixStorage<K, V> sto = this.storage();
        return CacheUtils.max(sto.cache().getName(), sto.keyMapper(), sto.valueMapper());
    }

    @Override
    public double minValue() {
        CacheMatrixStorage<K, V> sto = this.storage();
        return CacheUtils.min(sto.cache().getName(), sto.keyMapper(), sto.valueMapper());
    }

    private Matrix mapOverValues(IgniteFunction<Double, Double> mapper) {
        CacheMatrixStorage<K, V> sto = this.storage();
        CacheUtils.map(sto.cache().getName(), sto.keyMapper(), sto.valueMapper(), mapper);
        return this;
    }
}

