/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distributed.keys.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class VectorBlockKey
implements org.apache.ignite.ml.math.distributed.keys.VectorBlockKey,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private long blockId;
    private UUID vectorUuid;
    private UUID affinityKey;

    public VectorBlockKey() {
    }

    public VectorBlockKey(long blockId, UUID vectorUuid, @Nullable UUID affinityKey) {
        assert (blockId >= 0L);
        assert (vectorUuid != null);
        this.blockId = blockId;
        this.vectorUuid = vectorUuid;
        this.affinityKey = affinityKey;
    }

    @Override
    public long blockId() {
        return this.blockId;
    }

    @Override
    public UUID dataStructureId() {
        return this.vectorUuid;
    }

    @Override
    public UUID affinityKey() {
        return this.affinityKey;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.vectorUuid);
        out.writeObject(this.affinityKey);
        out.writeLong(this.blockId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.vectorUuid = (UUID)in.readObject();
        this.affinityKey = (UUID)in.readObject();
        this.blockId = in.readLong();
    }

    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeUuid(this.vectorUuid);
        out.writeUuid(this.affinityKey);
        out.writeLong(this.blockId);
    }

    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.vectorUuid = in.readUuid();
        this.affinityKey = in.readUuid();
        this.blockId = in.readLong();
    }

    public int hashCode() {
        int res = 37;
        res = (int)((long)res + ((long)(res * 37) + this.blockId));
        res += res * 37 + this.vectorUuid.hashCode();
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VectorBlockKey that = (VectorBlockKey)obj;
        return this.blockId == that.blockId && this.vectorUuid.equals(that.vectorUuid) && F.eq((Object)this.affinityKey, (Object)that.affinityKey);
    }

    public String toString() {
        return S.toString(VectorBlockKey.class, (Object)this);
    }
}

