/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.decompositions;

import org.apache.ignite.ml.math.Destroyable;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class EigenDecomposition
implements Destroyable {
    private final int n;
    private final Matrix v;
    private final Vector d;
    private final Vector e;
    private double cdivr;
    private double cdivi;

    public EigenDecomposition(Matrix matrix) {
        this(matrix, EigenDecomposition.isSymmetric(matrix));
    }

    public EigenDecomposition(Matrix matrix, boolean isSymmetric) {
        this.n = matrix.columnSize();
        this.d = MatrixUtil.likeVector(matrix);
        this.e = MatrixUtil.likeVector(matrix);
        this.v = MatrixUtil.like(matrix);
        if (isSymmetric) {
            this.v.assign(matrix);
            this.tred2();
            this.tql2();
        } else {
            this.hqr2(this.orthes(matrix));
        }
    }

    public Matrix getV() {
        return MatrixUtil.like(this.v).assign(this.v);
    }

    public Vector getRealEigenValues() {
        return this.d;
    }

    public Vector getImagEigenvalues() {
        return this.e;
    }

    public Matrix getD() {
        Matrix res = MatrixUtil.like(this.v, this.d.size(), this.d.size());
        res.assign(0.0);
        res.viewDiagonal().assign(this.d);
        for (int i = 0; i < this.n; ++i) {
            double v = this.e.getX(i);
            if (v > 0.0) {
                res.setX(i, i + 1, v);
                continue;
            }
            if (!(v < 0.0)) continue;
            res.setX(i, i - 1, v);
        }
        return res;
    }

    @Override
    public void destroy() {
        this.e.destroy();
        this.v.destroy();
        this.d.destroy();
    }

    private void tred2() {
        this.d.assign(this.v.viewColumn(this.n - 1));
        for (int i = this.n - 1; i > 0; --i) {
            double scale = this.d.viewPart(0, i).kNorm(1.0);
            double h = 0.0;
            if (scale == 0.0) {
                this.e.setX(i, this.d.getX(i - 1));
                for (int j = 0; j < i; ++j) {
                    this.d.setX(j, this.v.getX(i - 1, j));
                    this.v.setX(i, j, 0.0);
                    this.v.setX(j, i, 0.0);
                }
            } else {
                int j;
                int j2;
                for (int k = 0; k < i; ++k) {
                    this.d.setX(k, this.d.getX(k) / scale);
                    h += this.d.getX(k) * this.d.getX(k);
                }
                double f = this.d.getX(i - 1);
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e.setX(i, scale * g);
                h -= f * g;
                this.d.setX(i - 1, f - g);
                for (j2 = 0; j2 < i; ++j2) {
                    this.e.setX(j2, 0.0);
                }
                for (j2 = 0; j2 < i; ++j2) {
                    f = this.d.getX(j2);
                    this.v.setX(j2, i, f);
                    g = this.e.getX(j2) + this.v.getX(j2, j2) * f;
                    for (int k = j2 + 1; k <= i - 1; ++k) {
                        g += this.v.getX(k, j2) * this.d.getX(k);
                        this.e.setX(k, this.e.getX(k) + this.v.getX(k, j2) * f);
                    }
                    this.e.setX(j2, g);
                }
                f = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    this.e.setX(j2, this.e.getX(j2) / h);
                    f += this.e.getX(j2) * this.d.getX(j2);
                }
                double hh = f / (h + h);
                for (j = 0; j < i; ++j) {
                    this.e.setX(j, this.e.getX(j) - hh * this.d.getX(j));
                }
                for (j = 0; j < i; ++j) {
                    f = this.d.getX(j);
                    g = this.e.getX(j);
                    for (int k = j; k <= i - 1; ++k) {
                        this.v.setX(k, j, this.v.getX(k, j) - (f * this.e.getX(k) + g * this.d.getX(k)));
                    }
                    this.d.setX(j, this.v.getX(i - 1, j));
                    this.v.setX(i, j, 0.0);
                }
            }
            this.d.setX(i, h);
        }
    }

    private Matrix orthes(Matrix matrix) {
        int m;
        Vector ort = MatrixUtil.likeVector(matrix);
        Matrix hessenBerg = MatrixUtil.like(matrix).assign(matrix);
        int low = 0;
        int high = this.n - 1;
        for (m = low + 1; m <= high - 1; ++m) {
            double f;
            Vector hCol = hessenBerg.viewColumn(m - 1).viewPart(m, high - m + 1);
            double scale = hCol.kNorm(1.0);
            if (scale == 0.0) continue;
            ort.viewPart(m, high - m + 1).map(hCol, Functions.plusMult(1.0 / scale));
            double h = ort.viewPart(m, high - m + 1).getLengthSquared();
            double g = Math.sqrt(h);
            if (ort.getX(m) > 0.0) {
                g = -g;
            }
            h -= ort.getX(m) * g;
            ort.setX(m, ort.getX(m) - g);
            Vector ortPiece = ort.viewPart(m, high - m + 1);
            for (int j = m; j < this.n; ++j) {
                f = ortPiece.dot(hessenBerg.viewColumn(j).viewPart(m, high - m + 1)) / h;
                hessenBerg.viewColumn(j).viewPart(m, high - m + 1).map(ortPiece, Functions.plusMult(-f));
            }
            for (int i = 0; i <= high; ++i) {
                f = ortPiece.dot(hessenBerg.viewRow(i).viewPart(m, high - m + 1)) / h;
                hessenBerg.viewRow(i).viewPart(m, high - m + 1).map(ortPiece, Functions.plusMult(-f));
            }
            ort.setX(m, scale * ort.getX(m));
            hessenBerg.setX(m, m - 1, scale * g);
        }
        this.v.assign(0.0);
        this.v.viewDiagonal().assign(1.0);
        for (m = high - 1; m >= low + 1; --m) {
            if (hessenBerg.getX(m, m - 1) == 0.0) continue;
            ort.viewPart(m + 1, high - m).assign(hessenBerg.viewColumn(m - 1).viewPart(m + 1, high - m));
            for (int j = m; j <= high; ++j) {
                double g = ort.viewPart(m, high - m + 1).dot(this.v.viewColumn(j).viewPart(m, high - m + 1));
                g = g / ort.getX(m) / hessenBerg.getX(m, m - 1);
                this.v.viewColumn(j).viewPart(m, high - m + 1).map(ort.viewPart(m, high - m + 1), Functions.plusMult(g));
            }
        }
        return hessenBerg;
    }

    private void tql2() {
        this.e.viewPart(0, this.n - 1).assign(this.e.viewPart(1, this.n - 1));
        this.e.setX(this.n - 1, 0.0);
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d.getX(l)) + Math.abs(this.e.getX(l)));
            for (m = l; m < this.n && !(Math.abs(this.e.getX(m)) <= eps * tst1); ++m) {
            }
            if (m > l) {
                do {
                    double c;
                    double g = this.d.getX(l);
                    double p = (this.d.getX(l + 1) - g) / (2.0 * this.e.getX(l));
                    double r = Math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d.setX(l, this.e.getX(l) / (p + r));
                    this.d.setX(l + 1, this.e.getX(l) * (p + r));
                    double dl1 = this.d.getX(l + 1);
                    double h = g - this.d.getX(l);
                    for (int i = l + 2; i < this.n; ++i) {
                        this.d.setX(i, this.d.getX(i) - h);
                    }
                    f += h;
                    p = this.d.getX(m);
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e.getX(l + 1);
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i = m - 1; i >= l; --i) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e.getX(i);
                        h = c * p;
                        r = Math.hypot(p, this.e.getX(i));
                        this.e.setX(i + 1, s * r);
                        s = this.e.getX(i) / r;
                        c = p / r;
                        p = c * this.d.getX(i) - s * g;
                        this.d.setX(i + 1, h + s * (c * g + s * this.d.getX(i)));
                        for (int k = 0; k < this.n; ++k) {
                            h = this.v.getX(k, i + 1);
                            this.v.setX(k, i + 1, s * this.v.getX(k, i) + c * h);
                            this.v.setX(k, i, c * this.v.getX(k, i) - s * h);
                        }
                    }
                    p = -s * s2 * c3 * el1 * this.e.getX(l) / dl1;
                    this.e.setX(l, s * p);
                    this.d.setX(l, c * p);
                } while (Math.abs(this.e.getX(l)) > eps * tst1);
            }
            this.d.setX(l, this.d.getX(l) + f);
            this.e.setX(l, 0.0);
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int j;
            int k = i;
            double p = this.d.getX(i);
            for (j = i + 1; j < this.n; ++j) {
                if (!(this.d.getX(j) > p)) continue;
                k = j;
                p = this.d.getX(j);
            }
            if (k == i) continue;
            this.d.setX(k, this.d.getX(i));
            this.d.setX(i, p);
            for (j = 0; j < this.n; ++j) {
                p = this.v.getX(j, i);
                this.v.setX(j, i, this.v.getX(j, k));
                this.v.setX(j, k, p);
            }
        }
    }

    private void hqr2(Matrix h) {
        int k;
        double y;
        int i;
        int j;
        double x;
        double w;
        int nn = this.n;
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = h.foldMap(Functions.PLUS, Functions.ABS, 0.0);
        int iter = 0;
        block0: while (n >= low) {
            int m;
            int l;
            for (l = n; l > low; --l) {
                s = Math.abs(h.getX(l - 1, l - 1)) + Math.abs(h.getX(l, l));
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(h.getX(l, l - 1)) < eps * s) break;
            }
            if (l == n) {
                h.setX(n, n, h.getX(n, n) + exshift);
                this.d.setX(n, h.getX(n, n));
                this.e.setX(n, 0.0);
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = h.getX(n, n - 1) * h.getX(n - 1, n);
                p = (h.getX(n - 1, n - 1) - h.getX(n, n)) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                h.setX(n, n, h.getX(n, n) + exshift);
                h.setX(n - 1, n - 1, h.getX(n - 1, n - 1) + exshift);
                x = h.getX(n, n);
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d.setX(n - 1, x + z);
                    this.d.setX(n, this.d.getX(n - 1));
                    if (z != 0.0) {
                        this.d.setX(n, x - w / z);
                    }
                    this.e.setX(n - 1, 0.0);
                    this.e.setX(n, 0.0);
                    x = h.getX(n, n - 1);
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (j = n - 1; j < nn; ++j) {
                        z = h.getX(n - 1, j);
                        h.setX(n - 1, j, q * z + p * h.getX(n, j));
                        h.setX(n, j, q * h.getX(n, j) - p * z);
                    }
                    for (i = 0; i <= n; ++i) {
                        z = h.getX(i, n - 1);
                        h.setX(i, n - 1, q * z + p * h.getX(i, n));
                        h.setX(i, n, q * h.getX(i, n) - p * z);
                    }
                    for (i = low; i <= high; ++i) {
                        z = this.v.getX(i, n - 1);
                        this.v.setX(i, n - 1, q * z + p * this.v.getX(i, n));
                        this.v.setX(i, n, q * this.v.getX(i, n) - p * z);
                    }
                } else {
                    this.d.setX(n - 1, x + p);
                    this.d.setX(n, x + p);
                    this.e.setX(n - 1, z);
                    this.e.setX(n, -z);
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = h.getX(n, n);
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = h.getX(n - 1, n - 1);
                w = h.getX(n, n - 1) * h.getX(n - 1, n);
            }
            if (iter == 10) {
                exshift += x;
                for (i = low; i <= n; ++i) {
                    h.setX(i, i, x);
                }
                s = Math.abs(h.getX(n, n - 1)) + Math.abs(h.getX(n - 1, n - 2));
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    for (i = low; i <= n; ++i) {
                        h.setX(i, i, h.getX(i, i) - s);
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = h.getX(m, m);
                r = x - z;
                s = y - z;
                p = (r * s - w) / h.getX(m + 1, m) + h.getX(m, m + 1);
                q = h.getX(m + 1, m + 1) - z - r - s;
                r = h.getX(m + 2, m + 1);
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                p /= s;
                q /= s;
                r /= s;
                if (m == l) break;
                double hmag = Math.abs(h.getX(m - 1, m - 1)) + Math.abs(h.getX(m + 1, m + 1));
                double threshold = eps * Math.abs(p) * (Math.abs(z) + hmag);
                if (Math.abs(h.getX(m, m - 1)) * (Math.abs(q) + Math.abs(r)) < threshold) break;
            }
            for (int i2 = m + 2; i2 <= n; ++i2) {
                h.setX(i2, i2 - 2, 0.0);
                if (i2 <= m + 2) continue;
                h.setX(i2, i2 - 3, 0.0);
            }
            for (k = m; k <= n - 1; ++k) {
                int i3;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = h.getX(k, k - 1);
                    q = h.getX(k + 1, k - 1);
                    r = notlast ? h.getX(k + 2, k - 1) : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block0;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    h.setX(k, k - 1, -s * x);
                } else if (l != m) {
                    h.setX(k, k - 1, -h.getX(k, k - 1));
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j2 = k; j2 < nn; ++j2) {
                    p = h.getX(k, j2) + q * h.getX(k + 1, j2);
                    if (notlast) {
                        h.setX(k + 2, j2, h.getX(k + 2, j2) - (p += r * h.getX(k + 2, j2)) * z);
                    }
                    h.setX(k, j2, h.getX(k, j2) - p * x);
                    h.setX(k + 1, j2, h.getX(k + 1, j2) - p * y);
                }
                for (i3 = 0; i3 <= Math.min(n, k + 3); ++i3) {
                    p = x * h.getX(i3, k) + y * h.getX(i3, k + 1);
                    if (notlast) {
                        h.setX(i3, k + 2, h.getX(i3, k + 2) - (p += z * h.getX(i3, k + 2)) * r);
                    }
                    h.setX(i3, k, h.getX(i3, k) - p);
                    h.setX(i3, k + 1, h.getX(i3, k + 1) - p * q);
                }
                for (i3 = low; i3 <= high; ++i3) {
                    p = x * this.v.getX(i3, k) + y * this.v.getX(i3, k + 1);
                    if (notlast) {
                        this.v.setX(i3, k + 2, this.v.getX(i3, k + 2) - (p += z * this.v.getX(i3, k + 2)) * r);
                    }
                    this.v.setX(i3, k, this.v.getX(i3, k) - p);
                    this.v.setX(i3, k + 1, this.v.getX(i3, k + 1) - p * q);
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            int i4;
            int l;
            p = this.d.getX(n);
            q = this.e.getX(n);
            if (q == 0.0) {
                l = n;
                h.setX(n, n, 1.0);
                for (i4 = n - 1; i4 >= 0; --i4) {
                    int j3;
                    w = h.getX(i4, i4) - p;
                    r = 0.0;
                    for (j3 = l; j3 <= n; ++j3) {
                        r += h.getX(i4, j3) * h.getX(j3, n);
                    }
                    if (this.e.getX(i4) < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i4;
                    if (this.e.getX(i4) == 0.0) {
                        if (w == 0.0) {
                            h.setX(i4, n, -r / (eps * norm));
                        } else {
                            h.setX(i4, n, -r / w);
                        }
                    } else {
                        x = h.getX(i4, i4 + 1);
                        y = h.getX(i4 + 1, i4);
                        q = (this.d.getX(i4) - p) * (this.d.getX(i4) - p) + this.e.getX(i4) * this.e.getX(i4);
                        t = (x * s - z * r) / q;
                        h.setX(i4, n, t);
                        if (Math.abs(x) > Math.abs(z)) {
                            h.setX(i4 + 1, n, (-r - w * t) / x);
                        } else {
                            h.setX(i4 + 1, n, (-s - y * t) / z);
                        }
                    }
                    t = Math.abs(h.getX(i4, n));
                    if (!(eps * t * t > 1.0)) continue;
                    for (j3 = i4; j3 <= n; ++j3) {
                        h.setX(j3, n, h.getX(j3, n) / t);
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(h.getX(n, n - 1)) > Math.abs(h.getX(n - 1, n))) {
                h.setX(n - 1, n - 1, q / h.getX(n, n - 1));
                h.setX(n - 1, n, -(h.getX(n, n) - p) / h.getX(n, n - 1));
            } else {
                this.cdiv(0.0, -h.getX(n - 1, n), h.getX(n - 1, n - 1) - p, q);
                h.setX(n - 1, n - 1, this.cdivr);
                h.setX(n - 1, n, this.cdivi);
            }
            h.setX(n, n - 1, 0.0);
            h.setX(n, n, 1.0);
            for (i4 = n - 2; i4 >= 0; --i4) {
                int j4;
                double ra = 0.0;
                double sa = 0.0;
                for (j4 = l; j4 <= n; ++j4) {
                    ra += h.getX(i4, j4) * h.getX(j4, n - 1);
                    sa += h.getX(i4, j4) * h.getX(j4, n);
                }
                w = h.getX(i4, i4) - p;
                if (this.e.getX(i4) < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i4;
                if (this.e.getX(i4) == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    h.setX(i4, n - 1, this.cdivr);
                    h.setX(i4, n, this.cdivi);
                } else {
                    x = h.getX(i4, i4 + 1);
                    y = h.getX(i4 + 1, i4);
                    double vr = (this.d.getX(i4) - p) * (this.d.getX(i4) - p) + this.e.getX(i4) * this.e.getX(i4) - q * q;
                    double vi = (this.d.getX(i4) - p) * 2.0 * q;
                    if (vr == 0.0 && vi == 0.0) {
                        double hmag = Math.abs(x) + Math.abs(y);
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + hmag + Math.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    h.setX(i4, n - 1, this.cdivr);
                    h.setX(i4, n, this.cdivi);
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        h.setX(i4 + 1, n - 1, (-ra - w * h.getX(i4, n - 1) + q * h.getX(i4, n)) / x);
                        h.setX(i4 + 1, n, (-sa - w * h.getX(i4, n) - q * h.getX(i4, n - 1)) / x);
                    } else {
                        this.cdiv(-r - y * h.getX(i4, n - 1), -s - y * h.getX(i4, n), z, q);
                        h.setX(i4 + 1, n - 1, this.cdivr);
                        h.setX(i4 + 1, n, this.cdivi);
                    }
                }
                t = Math.max(Math.abs(h.getX(i4, n - 1)), Math.abs(h.getX(i4, n)));
                if (!(eps * t * t > 1.0)) continue;
                for (j4 = i4; j4 <= n; ++j4) {
                    h.setX(j4, n - 1, h.getX(j4, n - 1) / t);
                    h.setX(j4, n, h.getX(j4, n) / t);
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (i5 >= low && i5 <= high) continue;
            for (j = i5; j < nn; ++j) {
                this.v.setX(i5, j, h.getX(i5, j));
            }
        }
        for (int j5 = nn - 1; j5 >= low; --j5) {
            for (i = low; i <= high; ++i) {
                z = 0.0;
                for (k = low; k <= Math.min(j5, high); ++k) {
                    z += this.v.getX(i, k) * h.getX(k, j5);
                }
                this.v.setX(i, j5, z);
            }
        }
    }

    private static boolean isSymmetric(Matrix matrix) {
        int rows;
        int cols = matrix.columnSize();
        if (cols != (rows = matrix.rowSize())) {
            return false;
        }
        for (int i = 0; i < cols; ++i) {
            for (int j = 0; j < rows; ++j) {
                if (matrix.getX(i, j) == matrix.get(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }
}

