/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.ml.genetic.CrossOverJob;
import org.apache.ignite.ml.genetic.parameter.GAConfiguration;
import org.apache.ignite.resources.IgniteInstanceResource;

public class CrossOverTask
extends ComputeTaskAdapter<List<Long>, Boolean> {
    @IgniteInstanceResource
    private Ignite ignite = null;
    private GAConfiguration config = null;

    public CrossOverTask(GAConfiguration config) {
        this.config = config;
    }

    public Map map(List<ClusterNode> nodes, List<Long> chromosomeKeys) throws IgniteException {
        Map<ComputeJob, ClusterNode> map = new HashMap<ComputeJob, ClusterNode>();
        Affinity affinity = this.ignite.affinity("populationCache");
        Map nodeKeys = affinity.mapKeysToNodes(chromosomeKeys);
        for (Map.Entry entry : nodeKeys.entrySet()) {
            ClusterNode aNode = (ClusterNode)entry.getKey();
            map = this.setupCrossOver(aNode, (List)entry.getValue(), map);
        }
        return map;
    }

    public Boolean reduce(List<ComputeJobResult> list) throws IgniteException {
        return Boolean.TRUE;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        IgniteException err = res.getException();
        if (err != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }

    private Map<ComputeJob, ClusterNode> setupCrossOver(ClusterNode clusterNode, List<Long> keys, Map<ComputeJob, ClusterNode> map) {
        int numberOfJobs = keys.size() / 2;
        int k = 0;
        for (int i = 0; i < numberOfJobs; ++i) {
            Long key1 = keys.get(k);
            Long key2 = keys.get(k + 1);
            CrossOverJob job = new CrossOverJob(key1, key2, this.config.getCrossOverRate());
            map.put((ComputeJob)job, clusterNode);
            k += 2;
        }
        return map;
    }
}

