/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset;

import java.io.Serializable;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDatasetBuilder;
import org.apache.ignite.ml.dataset.impl.local.LocalDatasetBuilder;
import org.apache.ignite.ml.dataset.primitive.SimpleDataset;
import org.apache.ignite.ml.dataset.primitive.SimpleLabeledDataset;
import org.apache.ignite.ml.dataset.primitive.builder.context.EmptyContextBuilder;
import org.apache.ignite.ml.dataset.primitive.builder.data.SimpleDatasetDataBuilder;
import org.apache.ignite.ml.dataset.primitive.builder.data.SimpleLabeledDatasetDataBuilder;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;

public class DatasetFactory {
    public static <K, V, C extends Serializable, D extends AutoCloseable> Dataset<C, D> create(DatasetBuilder<K, V> datasetBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder) {
        return datasetBuilder.build(partCtxBuilder, partDataBuilder);
    }

    public static <K, V, C extends Serializable, D extends AutoCloseable> Dataset<C, D> create(Ignite ignite, IgniteCache<K, V> upstreamCache, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder) {
        return DatasetFactory.create(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), partCtxBuilder, partDataBuilder);
    }

    public static <K, V, C extends Serializable> SimpleDataset<C> createSimpleDataset(DatasetBuilder<K, V> datasetBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, IgniteBiFunction<K, V, double[]> featureExtractor) {
        return (SimpleDataset)DatasetFactory.create(datasetBuilder, partCtxBuilder, new SimpleDatasetDataBuilder(featureExtractor)).wrap(SimpleDataset::new);
    }

    public static <K, V, C extends Serializable> SimpleDataset<C> createSimpleDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, PartitionContextBuilder<K, V, C> partCtxBuilder, IgniteBiFunction<K, V, double[]> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), partCtxBuilder, featureExtractor);
    }

    public static <K, V, C extends Serializable> SimpleLabeledDataset<C> createSimpleLabeledDataset(DatasetBuilder<K, V> datasetBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, IgniteBiFunction<K, V, double[]> featureExtractor, IgniteBiFunction<K, V, double[]> lbExtractor) {
        return (SimpleLabeledDataset)DatasetFactory.create(datasetBuilder, partCtxBuilder, new SimpleLabeledDatasetDataBuilder(featureExtractor, lbExtractor)).wrap(SimpleLabeledDataset::new);
    }

    public static <K, V, C extends Serializable> SimpleLabeledDataset<C> createSimpleLabeledDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, PartitionContextBuilder<K, V, C> partCtxBuilder, IgniteBiFunction<K, V, double[]> featureExtractor, IgniteBiFunction<K, V, double[]> lbExtractor) {
        return DatasetFactory.createSimpleLabeledDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), partCtxBuilder, featureExtractor, lbExtractor);
    }

    public static <K, V> SimpleDataset<EmptyContext> createSimpleDataset(DatasetBuilder<K, V> datasetBuilder, IgniteBiFunction<K, V, double[]> featureExtractor) {
        return DatasetFactory.createSimpleDataset(datasetBuilder, new EmptyContextBuilder(), featureExtractor);
    }

    public static <K, V> SimpleDataset<EmptyContext> createSimpleDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, IgniteBiFunction<K, V, double[]> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), featureExtractor);
    }

    public static <K, V> SimpleLabeledDataset<EmptyContext> createSimpleLabeledDataset(DatasetBuilder<K, V> datasetBuilder, IgniteBiFunction<K, V, double[]> featureExtractor, IgniteBiFunction<K, V, double[]> lbExtractor) {
        return DatasetFactory.createSimpleLabeledDataset(datasetBuilder, new EmptyContextBuilder(), featureExtractor, lbExtractor);
    }

    public static <K, V> SimpleLabeledDataset<EmptyContext> createSimpleLabeledDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, IgniteBiFunction<K, V, double[]> featureExtractor, IgniteBiFunction<K, V, double[]> lbExtractor) {
        return DatasetFactory.createSimpleLabeledDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), featureExtractor, lbExtractor);
    }

    public static <K, V, C extends Serializable, D extends AutoCloseable> Dataset<C, D> create(Map<K, V> upstreamMap, int partitions, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder) {
        return DatasetFactory.create(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), partCtxBuilder, partDataBuilder);
    }

    public static <K, V, C extends Serializable> SimpleDataset<C> createSimpleDataset(Map<K, V> upstreamMap, int partitions, PartitionContextBuilder<K, V, C> partCtxBuilder, IgniteBiFunction<K, V, double[]> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), partCtxBuilder, featureExtractor);
    }

    public static <K, V, C extends Serializable> SimpleLabeledDataset<C> createSimpleLabeledDataset(Map<K, V> upstreamMap, int partitions, PartitionContextBuilder<K, V, C> partCtxBuilder, IgniteBiFunction<K, V, double[]> featureExtractor, IgniteBiFunction<K, V, double[]> lbExtractor) {
        return DatasetFactory.createSimpleLabeledDataset(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), partCtxBuilder, featureExtractor, lbExtractor);
    }

    public static <K, V> SimpleDataset<EmptyContext> createSimpleDataset(Map<K, V> upstreamMap, int partitions, IgniteBiFunction<K, V, double[]> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), featureExtractor);
    }

    public static <K, V> SimpleLabeledDataset<EmptyContext> createSimpleLabeledDataset(Map<K, V> upstreamMap, int partitions, IgniteBiFunction<K, V, double[]> featureExtractor, IgniteBiFunction<K, V, double[]> lbExtractor) {
        return DatasetFactory.createSimpleLabeledDataset(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), featureExtractor, lbExtractor);
    }
}

