/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskName;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.deployment.DeploymentListener;
import org.apache.ignite.spi.deployment.DeploymentResource;
import org.apache.ignite.spi.deployment.DeploymentResourceAdapter;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentClassLoader;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentFileProcessor;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentFileProcessorResult;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentUnitDescriptor;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentUriParser;
import org.apache.ignite.spi.deployment.uri.UriDeploymentSpiMBean;
import org.apache.ignite.spi.deployment.uri.scanners.GridUriDeploymentScannerListener;
import org.apache.ignite.spi.deployment.uri.scanners.UriDeploymentScanner;
import org.apache.ignite.spi.deployment.uri.scanners.UriDeploymentScannerManager;
import org.apache.ignite.spi.deployment.uri.scanners.file.UriDeploymentFileScanner;
import org.apache.ignite.spi.deployment.uri.scanners.http.UriDeploymentHttpScanner;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=false)
public class UriDeploymentSpi
extends IgniteSpiAdapter
implements DeploymentSpi {
    public static final String DFLT_DEPLOY_DIR = "deployment/file";
    public static final String XML_DESCRIPTOR_PATH = "META-INF/ignite.xml";
    public static final String DEPLOY_TMP_ROOT_NAME = "gg.uri.deployment.tmp";
    private String tmpDirPath;
    private String deployTmpDirPath;
    private List<String> uriList = new ArrayList<String>();
    private Collection<URI> uriEncodedList = new ArrayList<URI>();
    private boolean checkMd5;
    private final LinkedList<GridUriDeploymentUnitDescriptor> unitLoaders = new LinkedList();
    private final LastTimeUnitDescriptorComparator unitComp = new LastTimeUnitDescriptorComparator();
    private final Collection<UriDeploymentScannerManager> mgrs = new ArrayList<UriDeploymentScannerManager>();
    private boolean encodeUri = true;
    private int firstScanCntr;
    private volatile DeploymentListener lsnr;
    private final Object mux = new Object();
    @LoggerResource
    private IgniteLogger log;
    private boolean delayOnNewOrUpdatedFile;
    private UriDeploymentScanner[] scanners;

    @IgniteSpiConfiguration(optional=true)
    public UriDeploymentSpi setTemporaryDirectoryPath(String tmpDirPath) {
        this.tmpDirPath = tmpDirPath;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public UriDeploymentSpi setUriList(List<String> uriList) {
        this.uriList = uriList;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public UriDeploymentSpi setCheckMd5(boolean checkMd5) {
        this.checkMd5 = checkMd5;
        return this;
    }

    public boolean isCheckMd5() {
        return this.checkMd5;
    }

    @IgniteSpiConfiguration(optional=true)
    public UriDeploymentSpi setEncodeUri(boolean encodeUri) {
        this.encodeUri = encodeUri;
        return this;
    }

    public String getTemporaryDirectoryPath() {
        return this.tmpDirPath;
    }

    public List<String> getUriList() {
        return Collections.unmodifiableList(this.uriList);
    }

    public void setListener(@Nullable DeploymentListener lsnr) {
        this.lsnr = lsnr;
    }

    public UriDeploymentScanner[] getScanners() {
        return this.scanners;
    }

    @IgniteSpiConfiguration(optional=true)
    public UriDeploymentSpi setScanners(UriDeploymentScanner ... scanners) {
        this.scanners = scanners;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiStop() throws IgniteSpiException {
        ArrayList<ClassLoader> tmpClsLdrs;
        for (UriDeploymentScannerManager mgr : this.mgrs) {
            mgr.cancel();
        }
        for (UriDeploymentScannerManager mgr : this.mgrs) {
            mgr.join();
        }
        this.uriEncodedList.clear();
        this.mgrs.clear();
        Iterator iterator = this.mux;
        synchronized (iterator) {
            tmpClsLdrs = new ArrayList<ClassLoader>(this.unitLoaders.size());
            for (GridUriDeploymentUnitDescriptor desc : this.unitLoaders) {
                tmpClsLdrs.add(desc.getClassLoader());
            }
        }
        for (ClassLoader ldr : tmpClsLdrs) {
            this.onUnitReleased(ldr);
        }
        if (this.deployTmpDirPath != null) {
            U.delete((File)new File(this.deployTmpDirPath));
        }
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        this.startStopwatch();
        this.assertParameter(this.uriList != null, "uriList != null");
        this.initializeUriList();
        if (this.uriEncodedList.isEmpty()) {
            this.addDefaultUri();
        }
        this.initializeTemporaryDirectoryPath();
        this.registerMBean(igniteInstanceName, new UriDeploymentSpiMBeanImpl(this), UriDeploymentSpiMBean.class);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                assert (name != null);
                return name.toLowerCase().endsWith(".gar");
            }
        };
        this.firstScanCntr = 0;
        GridUriDeploymentScannerListener lsnr = new GridUriDeploymentScannerListener(){

            @Override
            public void onNewOrUpdatedFile(File file, String uri, long tstamp) {
                if (UriDeploymentSpi.this.log.isInfoEnabled()) {
                    UriDeploymentSpi.this.log.info("Found new or updated GAR units [uri=" + U.hidePassword((String)uri) + ", file=" + file.getAbsolutePath() + ", tstamp=" + tstamp + ']');
                }
                if (UriDeploymentSpi.this.delayOnNewOrUpdatedFile) {
                    U.warn((IgniteLogger)UriDeploymentSpi.this.log, (Object)"Delaying onNewOrUpdatedFile() by 10000 ms since 'delayOnNewOrUpdatedFile' is set to true (is this intentional?).");
                    try {
                        U.sleep((long)10000L);
                    }
                    catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                        // empty catch block
                    }
                    U.warn((IgniteLogger)UriDeploymentSpi.this.log, (Object)"Delay finished.");
                }
                try {
                    GridUriDeploymentFileProcessorResult fileRes = GridUriDeploymentFileProcessor.processFile(file, uri, new File(UriDeploymentSpi.this.deployTmpDirPath), UriDeploymentSpi.this.log);
                    if (fileRes != null) {
                        UriDeploymentSpi.this.newUnitReceived(uri, fileRes.getFile(), tstamp, fileRes.getClassLoader(), fileRes.getTaskClasses(), fileRes.getMd5());
                    }
                }
                catch (IgniteSpiException e) {
                    U.error((IgniteLogger)UriDeploymentSpi.this.log, (Object)("Error when processing file: " + file.getAbsolutePath()), (Throwable)e);
                }
            }

            @Override
            public void onDeletedFiles(List<String> uris) {
                if (UriDeploymentSpi.this.log.isInfoEnabled()) {
                    ArrayList<String> uriList = null;
                    if (uris != null) {
                        uriList = new ArrayList<String>();
                        for (String uri : uris) {
                            uriList.add(U.hidePassword((String)uri));
                        }
                    }
                    if (UriDeploymentSpi.this.log.isInfoEnabled()) {
                        UriDeploymentSpi.this.log.info("Found deleted GAR units [uris=" + uriList + ']');
                    }
                }
                UriDeploymentSpi.this.processDeletedFiles(uris);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFirstScanFinished() {
                Object object = UriDeploymentSpi.this.mux;
                synchronized (object) {
                    UriDeploymentSpi.this.firstScanCntr++;
                    if (UriDeploymentSpi.this.isFirstScanFinished(UriDeploymentSpi.this.firstScanCntr)) {
                        UriDeploymentSpi.this.mux.notifyAll();
                    }
                }
            }
        };
        if (this.scanners == null) {
            this.scanners = new UriDeploymentScanner[2];
            this.scanners[0] = new UriDeploymentFileScanner();
            this.scanners[1] = new UriDeploymentHttpScanner();
        }
        for (URI uri : this.uriEncodedList) {
            File file = new File(this.deployTmpDirPath);
            long freq = -1L;
            try {
                freq = this.getFrequencyFromUri(uri);
            }
            catch (NumberFormatException e) {
                U.error((IgniteLogger)this.log, (Object)"Error parsing parameter value for frequency.", (Throwable)e);
            }
            UriDeploymentScannerManager mgr = null;
            for (UriDeploymentScanner scanner : this.scanners) {
                if (!scanner.acceptsURI(uri)) continue;
                mgr = new UriDeploymentScannerManager(igniteInstanceName, uri, file, freq > 0L ? freq : scanner.getDefaultScanFrequency(), filter, lsnr, this.log, scanner);
                break;
            }
            if (mgr == null) {
                throw new IgniteSpiException("Unsupported URI (please configure appropriate scanner): " + uri);
            }
            this.mgrs.add(mgr);
            mgr.start();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("tmpDirPath", this.tmpDirPath));
            this.log.debug(this.configInfo("uriList", this.uriList));
            this.log.debug(this.configInfo("encodeUri", this.encodeUri));
            this.log.debug(this.configInfo("scanners", this.mgrs));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    private long getFrequencyFromUri(URI uri) throws NumberFormatException {
        String[] arr;
        assert (uri != null);
        String userInfo = uri.getUserInfo();
        if (userInfo != null && (arr = userInfo.split(";")).length > 0) {
            for (String el : arr) {
                if (!el.startsWith("freq=")) continue;
                return Long.parseLong(el.substring(5));
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DeploymentResource findResource(String rsrcName) {
        Object object;
        assert (rsrcName != null);
        try {
            object = this.mux;
            synchronized (object) {
                while (!this.isFirstScanFinished(this.firstScanCntr)) {
                    this.mux.wait(5000L);
                }
            }
        }
        catch (InterruptedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to wait while all scanner managers finish their first scanning.", (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        object = this.mux;
        synchronized (object) {
            for (GridUriDeploymentUnitDescriptor unitDesc : this.unitLoaders) {
                String clsName = rsrcName;
                Class<?> clsByAlias = unitDesc.getResourcesByAlias().get(rsrcName);
                if (clsByAlias != null) {
                    clsName = clsByAlias.getName();
                }
                try {
                    Class<?> cls;
                    ClassLoader ldr = unitDesc.getClassLoader();
                    Class<?> clazz = cls = ldr instanceof GridUriDeploymentClassLoader ? ((GridUriDeploymentClassLoader)ldr).loadClassGarOnly(clsName) : ldr.loadClass(clsName);
                    assert (cls != null);
                    IgniteBiTuple<Class<?>, String> rsrc = unitDesc.findResource(rsrcName);
                    if (rsrc != null) {
                        String alias = (String)rsrc.get2();
                        String string = alias != null ? alias : rsrcName;
                        return new DeploymentResourceAdapter(string, cls, unitDesc.getClassLoader());
                    }
                    if (ComputeTask.class.isAssignableFrom(cls)) continue;
                    unitDesc.addResource(cls);
                    return new DeploymentResourceAdapter(rsrcName, cls, unitDesc.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(ClassLoader ldr, Class<?> rsrc) throws IgniteSpiException {
        Map<String, String> newRsrcs;
        A.notNull((Object)ldr, (String)"ldr");
        A.notNull(rsrc, (String)"rsrc");
        long tstamp = U.currentTimeMillis();
        ArrayList<ClassLoader> rmvClsLdrs = new ArrayList<ClassLoader>();
        Iterator iterator = this.mux;
        synchronized (iterator) {
            GridUriDeploymentUnitDescriptor desc = null;
            for (GridUriDeploymentUnitDescriptor unitDesc : this.unitLoaders) {
                if (!unitDesc.getClassLoader().equals(ldr)) continue;
                desc = unitDesc;
                break;
            }
            if (desc == null) {
                desc = new GridUriDeploymentUnitDescriptor(tstamp, ldr);
                assert (this.unitLoaders.size() <= 0 || this.unitComp.compare(desc, this.unitLoaders.getFirst()) <= 0);
                this.unitLoaders.addFirst(desc);
            }
            if (!F.isEmpty(newRsrcs = this.addResources(ldr, desc, new Class[]{rsrc}))) {
                this.removeResources(ldr, newRsrcs, rmvClsLdrs);
            }
        }
        for (ClassLoader cldLdr : rmvClsLdrs) {
            this.onUnitReleased(cldLdr);
        }
        return !F.isEmpty(newRsrcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(String rsrcName) {
        boolean rmv;
        assert (rsrcName != null);
        ArrayList<ClassLoader> rmvClsLdrs = new ArrayList<ClassLoader>();
        Iterator iterator = this.mux;
        synchronized (iterator) {
            HashMap rsrcs = U.newHashMap((int)1);
            rsrcs.put(rsrcName, rsrcName);
            rmv = this.removeResources(null, rsrcs, rmvClsLdrs);
        }
        for (ClassLoader cldLdr : rmvClsLdrs) {
            this.onUnitReleased(cldLdr);
        }
        return rmv;
    }

    @Nullable
    private Map<String, String> addResources(ClassLoader ldr, GridUriDeploymentUnitDescriptor desc, Class<?>[] clss) throws IgniteSpiException {
        assert (ldr != null);
        assert (desc != null);
        assert (clss != null);
        HashMap alias2Cls = new HashMap(clss.length * 2, 1.0f);
        for (Class<?> cls : clss) {
            ComputeTaskName nameAnn;
            String alias = null;
            if (ComputeTask.class.isAssignableFrom(cls) && (nameAnn = (ComputeTaskName)U.getAnnotation(cls, ComputeTaskName.class)) != null) {
                alias = nameAnn.value();
            }
            if (alias != null && alias2Cls.containsKey(alias) && !((Class)alias2Cls.get(alias)).equals(cls)) {
                throw new IgniteSpiException("Failed to register resources with given task name (found another class with same task name) [taskName=" + alias + ", cls1=" + cls.getName() + ", cls2=" + ((Class)alias2Cls.get(alias)).getName() + ", ldr=" + ldr + ']');
            }
            if (alias != null) {
                alias2Cls.put(alias, cls);
                desc.addResource(alias, cls);
                continue;
            }
            desc.addResource(cls);
        }
        Map newRsrcs = null;
        for (Map.Entry entry : alias2Cls.entrySet()) {
            String newAlias = (String)entry.getKey();
            String newName = ((Class)entry.getValue()).getName();
            Class<?> cls = desc.getResourceByAlias(newAlias);
            if (cls != null) {
                if (cls.getName().equals(newName)) continue;
                throw new IgniteSpiException("Failed to register resources with given task name (found another class with same task name in the same class loader) [taskName=" + newAlias + ", existingCls=" + cls.getName() + ", newCls=" + newName + ", ldr=" + ldr + ']');
            }
            if (newRsrcs == null) {
                newRsrcs = U.newHashMap((int)(alias2Cls.size() + clss.length));
            }
            newRsrcs.put(newAlias, newName);
            newRsrcs.put(newName, newName);
        }
        return newRsrcs;
    }

    private boolean removeResources(@Nullable ClassLoader ignoreClsLdr, Map<String, String> rsrcs, Collection<ClassLoader> rmvClsLdrs) {
        assert (Thread.holdsLock(this.mux));
        assert (rsrcs != null);
        boolean res = false;
        Iterator iter = this.unitLoaders.iterator();
        block0: while (iter.hasNext()) {
            GridUriDeploymentUnitDescriptor desc = (GridUriDeploymentUnitDescriptor)iter.next();
            ClassLoader ldr = desc.getClassLoader();
            if (ignoreClsLdr != null && ldr.equals(ignoreClsLdr)) continue;
            boolean isRmv = false;
            for (String string : rsrcs.keySet()) {
                IgniteBiTuple<Class<?>, String> rsrc = desc.findResource(string);
                if (rsrc == null) continue;
                iter.remove();
                rmvClsLdrs.add(ldr);
                isRmv = true;
                res = true;
                break;
            }
            if (isRmv) continue;
            for (Map.Entry entry : rsrcs.entrySet()) {
                if (!((String)entry.getKey()).equals(entry.getValue()) || !this.isResourceExist(ldr, (String)entry.getKey())) continue;
                iter.remove();
                rmvClsLdrs.add(ldr);
                res = true;
                continue block0;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isResourceExist(ClassLoader ldr, String clsName) {
        boolean bl;
        String rsrc = clsName.replaceAll("\\.", "/") + ".class";
        InputStream in = null;
        try {
            in = ldr instanceof GridUriDeploymentClassLoader ? ((GridUriDeploymentClassLoader)ldr).getResourceAsStreamGarOnly(rsrc) : ldr.getResourceAsStream(rsrc);
            bl = in != null;
        }
        catch (Throwable throwable) {
            U.close(in, (IgniteLogger)this.log);
            throw throwable;
        }
        U.close((AutoCloseable)in, (IgniteLogger)this.log);
        return bl;
    }

    private boolean isFirstScanFinished(int cntr) {
        assert (this.uriEncodedList != null);
        return cntr >= this.uriEncodedList.size();
    }

    private void initializeUriList() throws IgniteSpiException {
        for (String uri : this.uriList) {
            URI uriObj;
            this.assertParameter(uri != null, "uriList.get(X) != null");
            String encUri = this.encodeUri(uri.replaceAll("\\\\", "/"));
            try {
                uriObj = new URI(encUri);
            }
            catch (URISyntaxException e) {
                throw new IgniteSpiException("Failed to parse URI [uri=" + U.hidePassword((String)uri) + ", encodedUri=" + U.hidePassword((String)encUri) + ']', (Throwable)e);
            }
            if (uriObj.getScheme() == null || uriObj.getScheme().trim().isEmpty()) {
                throw new IgniteSpiException("Failed to get 'scheme' from URI [uri=" + U.hidePassword((String)uri) + ", encodedUri=" + U.hidePassword((String)encUri) + ']');
            }
            this.uriEncodedList.add(uriObj);
        }
    }

    private void addDefaultUri() throws IgniteSpiException {
        URI uri;
        assert (this.uriEncodedList != null);
        try {
            uri = U.resolveWorkDirectory((String)this.ignite.configuration().getWorkDirectory(), (String)DFLT_DEPLOY_DIR, (boolean)false).toURI();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to initialize default file scanner", (Throwable)e);
        }
        this.uriEncodedList.add(uri);
    }

    private String encodeUri(String path) {
        return this.encodeUri ? new GridUriDeploymentUriParser(path).parse() : path;
    }

    private void initializeTemporaryDirectoryPath() throws IgniteSpiException {
        String tmpDirPath;
        String string = tmpDirPath = this.tmpDirPath == null ? System.getProperty("java.io.tmpdir") : this.tmpDirPath;
        if (tmpDirPath == null) {
            throw new IgniteSpiException("Error initializing temporary deployment directory.");
        }
        File dir = new File(tmpDirPath + File.separator + DEPLOY_TMP_ROOT_NAME + File.separator + this.ignite.configuration().getNodeId());
        if (!U.mkdirs((File)dir)) {
            throw new IgniteSpiException("Error initializing temporary deployment directory: " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IgniteSpiException("Temporary deployment directory path is not a valid directory: " + dir);
        }
        if (!dir.canRead() || !dir.canWrite()) {
            throw new IgniteSpiException("Can not write to or read from temporary deployment directory: " + dir);
        }
        this.tmpDirPath = tmpDirPath;
        this.deployTmpDirPath = dir.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newUnitReceived(GridUriDeploymentUnitDescriptor newDesc, Collection<Class<?>> clss) {
        assert (newDesc != null);
        assert (newDesc.getType() == GridUriDeploymentUnitDescriptor.Type.FILE);
        if (clss != null && !clss.isEmpty()) {
            try {
                this.addResources(newDesc.getClassLoader(), newDesc, clss.toArray(new Class[clss.size()]));
            }
            catch (IgniteSpiException e) {
                U.warn((IgniteLogger)this.log, (Object)("Failed to register GAR class loader [newDesc=" + newDesc + ", msg=" + e.getMessage() + ']'));
            }
        }
        ArrayList<ClassLoader> rmvClsLdrs = new ArrayList<ClassLoader>();
        Iterator iterator = this.mux;
        synchronized (iterator) {
            if (this.checkMd5 && this.unitDeployed(newDesc.getMd5())) {
                if (this.log.isInfoEnabled()) {
                    LT.info((IgniteLogger)this.log, (String)("Skipping new deployment unit because of md5 match [uri='" + U.hidePassword((String)newDesc.getUri()) + "', file=" + (newDesc.getFile() == null ? "N/A" : newDesc.getFile()) + ']'));
                }
                return;
            }
            boolean isAdded = false;
            boolean ignoreNewUnit = false;
            ListIterator<GridUriDeploymentUnitDescriptor> iter = this.unitLoaders.listIterator();
            while (iter.hasNext()) {
                GridUriDeploymentUnitDescriptor desc = (GridUriDeploymentUnitDescriptor)iter.next();
                assert (!newDesc.getClassLoader().equals(desc.getClassLoader())) : "URI scanners always create new class loader for every GAR file: " + newDesc;
                if (desc.getType() == GridUriDeploymentUnitDescriptor.Type.FILE && newDesc.getUri().equals(desc.getUri()) && !newDesc.getFile().equals(desc.getFile())) {
                    iter.remove();
                    rmvClsLdrs.add(desc.getClassLoader());
                    if (iter.hasNext()) continue;
                    break;
                }
                if (!isAdded) {
                    if (this.unitComp.compare(newDesc, desc) <= 0) {
                        if (this.checkUnitCollision(desc, newDesc)) {
                            iter.remove();
                            iter.add(newDesc);
                            rmvClsLdrs.add(desc.getClassLoader());
                        } else {
                            iter.set(newDesc);
                            iter.add(desc);
                        }
                        isAdded = true;
                        continue;
                    }
                    if (!this.checkUnitCollision(newDesc, desc)) continue;
                    ignoreNewUnit = true;
                    break;
                }
                if (!this.checkUnitCollision(newDesc, desc)) continue;
                iter.remove();
                rmvClsLdrs.add(desc.getClassLoader());
            }
            if (!ignoreNewUnit) {
                if (!isAdded) {
                    this.unitLoaders.add(newDesc);
                }
                if (this.log.isDebugEnabled()) {
                    LT.info((IgniteLogger)this.log, (String)("Class loader (re)registered [clsLdr=" + newDesc.getClassLoader() + ", tstamp=" + newDesc.getTimestamp() + ", uri='" + U.hidePassword((String)newDesc.getUri()) + "', file=" + (newDesc.getFile() == null ? "N/A" : newDesc.getFile()) + ']'));
                }
            }
        }
        for (ClassLoader cldLdr : rmvClsLdrs) {
            this.onUnitReleased(cldLdr);
        }
    }

    private boolean checkUnitCollision(GridUriDeploymentUnitDescriptor newDesc, GridUriDeploymentUnitDescriptor existDesc) {
        assert (newDesc != null);
        assert (existDesc != null);
        Map<String, Class<?>> rsrcsByAlias = newDesc.getResourcesByAlias();
        for (Map.Entry<String, Class<?>> entry : existDesc.getResourcesByAlias().entrySet()) {
            String rsrcName = entry.getKey();
            if (!rsrcsByAlias.containsKey(rsrcName)) continue;
            U.warn((IgniteLogger)this.log, (Object)("Found collision with task name in different GAR files. Class loader will be removed [taskName=" + rsrcName + ", cls1=" + rsrcsByAlias.get(rsrcName) + ", cls2=" + entry.getValue() + ", newDesc=" + newDesc + ", existDesc=" + existDesc + ']'));
            return true;
        }
        for (Class clazz : existDesc.getResources()) {
            if (ComputeTask.class.isAssignableFrom(clazz) || !this.isResourceExist(newDesc.getClassLoader(), clazz.getName())) continue;
            U.warn((IgniteLogger)this.log, (Object)("Found collision with task class in different GAR files. Class loader will be removed [taskCls=" + clazz + ", removedDesc=" + newDesc + ", existDesc=" + existDesc + ']'));
            return true;
        }
        return false;
    }

    private void newUnitReceived(String uri, File file, long tstamp, ClassLoader ldr, Collection<Class<? extends ComputeTask<?, ?>>> clss, @Nullable String md5) {
        assert (uri != null);
        assert (file != null);
        assert (tstamp > 0L);
        tstamp = Math.min(tstamp, U.currentTimeMillis());
        GridUriDeploymentUnitDescriptor desc = new GridUriDeploymentUnitDescriptor(uri, file, tstamp, ldr, md5);
        this.newUnitReceived(desc, clss != null && !clss.isEmpty() ? new ArrayList(clss) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeletedFiles(List<String> uris) {
        assert (uris != null);
        if (uris.isEmpty()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            HashSet<String> uriSet = new HashSet<String>(uris);
            Iterator iter = this.unitLoaders.iterator();
            while (iter.hasNext()) {
                GridUriDeploymentUnitDescriptor desc = (GridUriDeploymentUnitDescriptor)iter.next();
                if (desc.getType() != GridUriDeploymentUnitDescriptor.Type.FILE || !uriSet.contains(desc.getUri())) continue;
                iter.remove();
                this.onUnitReleased(desc.getClassLoader());
            }
        }
    }

    private void onUnitReleased(ClassLoader clsLdr) {
        DeploymentListener tmp;
        if (!clsLdr.equals(((Object)((Object)this)).getClass().getClassLoader())) {
            GridUriDeploymentFileProcessor.cleanupUnit(clsLdr, this.log);
        }
        if ((tmp = this.lsnr) != null) {
            tmp.onUnregistered(clsLdr);
        }
    }

    private boolean unitDeployed(String md5) {
        assert (Thread.holdsLock(this.mux));
        if (md5 != null) {
            for (GridUriDeploymentUnitDescriptor d : this.unitLoaders) {
                if (!md5.equals(d.getMd5())) continue;
                return true;
            }
        }
        return false;
    }

    public IgniteSpiAdapter setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(UriDeploymentSpi.class, (Object)((Object)this));
    }

    private class UriDeploymentSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements UriDeploymentSpiMBean {
        UriDeploymentSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        @Override
        public String getTemporaryDirectoryPath() {
            return UriDeploymentSpi.this.getTemporaryDirectoryPath();
        }

        @Override
        public List<String> getUriList() {
            return UriDeploymentSpi.this.getUriList();
        }

        @Override
        public boolean isCheckMd5() {
            return UriDeploymentSpi.this.isCheckMd5();
        }
    }

    private static class LastTimeUnitDescriptorComparator
    implements Comparator<GridUriDeploymentUnitDescriptor>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private LastTimeUnitDescriptorComparator() {
        }

        @Override
        public int compare(GridUriDeploymentUnitDescriptor o1, GridUriDeploymentUnitDescriptor o2) {
            if (o1.getTimestamp() < o2.getTimestamp()) {
                return 1;
            }
            return o1.getTimestamp() == o2.getTimestamp() ? 0 : -1;
        }
    }
}

