/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements SelectorManager.SelectableEndPoint {
    public static final Logger LOG = Log.getLogger(SelectChannelEndPoint.class);
    private final Runnable _updateTask = new Runnable(){

        @Override
        public void run() {
            try {
                if (SelectChannelEndPoint.this.getChannel().isOpen()) {
                    int oldInterestOps = SelectChannelEndPoint.this._key.interestOps();
                    int newInterestOps = SelectChannelEndPoint.this._interestOps.get();
                    if (newInterestOps != oldInterestOps) {
                        SelectChannelEndPoint.this.setKeyInterests(oldInterestOps, newInterestOps);
                    }
                }
            }
            catch (CancelledKeyException x) {
                LOG.debug("Ignoring key update for concurrently closed channel {}", this);
                SelectChannelEndPoint.this.close();
            }
            catch (Exception x) {
                LOG.warn("Ignoring key update for " + this, x);
                SelectChannelEndPoint.this.close();
            }
        }
    };
    private final AtomicBoolean _open = new AtomicBoolean();
    private final SelectorManager.ManagedSelector _selector;
    private final SelectionKey _key;
    private final AtomicInteger _interestOps = new AtomicInteger();

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key, Scheduler scheduler, long idleTimeout) {
        super(scheduler, channel);
        this._selector = selector;
        this._key = key;
        this.setIdleTimeout(idleTimeout);
    }

    @Override
    protected boolean needsFill() {
        this.updateLocalInterests(1, true);
        return false;
    }

    @Override
    protected void onIncompleteFlush() {
        this.updateLocalInterests(4, true);
    }

    @Override
    public void onSelected() {
        assert (this._selector.isSelectorThread());
        int oldInterestOps = this._key.interestOps();
        int readyOps = this._key.readyOps();
        int newInterestOps = oldInterestOps & ~readyOps;
        this.setKeyInterests(oldInterestOps, newInterestOps);
        this.updateLocalInterests(readyOps, false);
        if (this._key.isReadable()) {
            this.getFillInterest().fillable();
        }
        if (this._key.isWritable()) {
            this.getWriteFlusher().completeWrite();
        }
    }

    private void updateLocalInterests(int operation, boolean add) {
        block5: {
            int newInterestOps;
            int oldInterestOps;
            while (true) {
                oldInterestOps = this._interestOps.get();
                newInterestOps = add ? oldInterestOps | operation : oldInterestOps & ~operation;
                if (this.isInputShutdown()) {
                    newInterestOps &= 0xFFFFFFFE;
                }
                if (this.isOutputShutdown()) {
                    newInterestOps &= 0xFFFFFFFB;
                }
                if (newInterestOps == oldInterestOps) break;
                if (this._interestOps.compareAndSet(oldInterestOps, newInterestOps)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Local interests updating {} -> {} for {}", oldInterestOps, newInterestOps, this);
                    }
                    this._selector.updateKey(this._updateTask);
                    break block5;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Local interests update conflict: now {}, was {}, attempted {} for {}", this._interestOps.get(), oldInterestOps, newInterestOps, this);
            }
            if (!LOG.isDebugEnabled()) break block5;
            LOG.debug("Ignoring local interests update {} -> {} for {}", oldInterestOps, newInterestOps, this);
        }
    }

    private void setKeyInterests(int oldInterestOps, int newInterestOps) {
        this._key.interestOps(newInterestOps);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Key interests updated {} -> {} on {}", oldInterestOps, newInterestOps, this);
        }
    }

    @Override
    public void close() {
        if (this._open.compareAndSet(true, false)) {
            super.close();
            this._selector.destroyEndPoint(this);
        }
    }

    @Override
    public boolean isOpen() {
        return this._open.get();
    }

    @Override
    public void onOpen() {
        if (this._open.compareAndSet(false, true)) {
            super.onOpen();
        }
    }

    @Override
    public String toString() {
        try {
            boolean valid = this._key != null && this._key.isValid();
            int keyInterests = valid ? this._key.interestOps() : -1;
            int keyReadiness = valid ? this._key.readyOps() : -1;
            return String.format("%s{io=%d,kio=%d,kro=%d}", super.toString(), this._interestOps.get(), keyInterests, keyReadiness);
        }
        catch (CancelledKeyException x) {
            return String.format("%s{io=%s,kio=-2,kro=-2}", super.toString(), this._interestOps.get());
        }
    }
}

