/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.twitter;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.twitter.hbc.ClientBuilder;
import com.twitter.hbc.core.Client;
import com.twitter.hbc.core.Hosts;
import com.twitter.hbc.core.HttpHosts;
import com.twitter.hbc.core.endpoint.DefaultStreamingEndpoint;
import com.twitter.hbc.core.endpoint.SitestreamEndpoint;
import com.twitter.hbc.core.endpoint.StatusesFilterEndpoint;
import com.twitter.hbc.core.endpoint.StatusesFirehoseEndpoint;
import com.twitter.hbc.core.endpoint.StatusesSampleEndpoint;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import com.twitter.hbc.core.endpoint.UserstreamEndpoint;
import com.twitter.hbc.core.processor.HosebirdMessageProcessor;
import com.twitter.hbc.core.processor.StringDelimitedProcessor;
import com.twitter.hbc.httpclient.auth.Authentication;
import com.twitter.hbc.httpclient.auth.OAuth1;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.stream.StreamAdapter;
import org.apache.ignite.stream.twitter.OAuthSettings;

public class TwitterStreamer<K, V>
extends StreamAdapter<String, K, V> {
    protected IgniteLogger log;
    private int threadsCount = 1;
    private Map<String, String> apiParams;
    private String endpointUrl;
    private OAuthSettings oAuthSettings;
    private final AtomicInteger running = new AtomicInteger();
    private Integer bufferCapacity = 100000;
    private Client client;
    private ExecutorService tweetStreamProcessor;
    private final String SITE_USER_ID_KEY = "follow";

    public TwitterStreamer(OAuthSettings oAuthSettings) {
        this.oAuthSettings = oAuthSettings;
    }

    public void start() {
        if (!this.running.compareAndSet(0, 1)) {
            throw new IgniteException("Attempted to start an already started Twitter Streamer");
        }
        this.validateConfig();
        this.log = this.getIgnite().log();
        final LinkedBlockingQueue<String> tweetQueue = new LinkedBlockingQueue<String>(this.bufferCapacity);
        this.client = this.getClient(tweetQueue);
        this.client.connect();
        this.tweetStreamProcessor = Executors.newFixedThreadPool(this.threadsCount);
        for (int i = 0; i < this.threadsCount; ++i) {
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        while (true) {
                            String tweet = (String)tweetQueue.take();
                            TwitterStreamer.this.addMessage(tweet);
                        }
                    }
                    catch (InterruptedException e) {
                        U.warn((IgniteLogger)TwitterStreamer.this.log, (Object)"Tweets transformation was interrupted", (Object)e);
                        return true;
                    }
                }
            };
            this.tweetStreamProcessor.submit(task);
        }
    }

    public void stop() {
        if (this.running.get() == 0) {
            throw new IgniteException("Attempted to stop an already stopped Twitter Streamer");
        }
        this.tweetStreamProcessor.shutdownNow();
        this.client.stop();
        this.running.compareAndSet(1, 0);
    }

    protected void validateConfig() {
        A.notNull((Object)this.getStreamer(), (String)"Streamer");
        A.notNull((Object)this.getIgnite(), (String)"Ignite");
        A.notNull((Object)this.endpointUrl, (String)"Twitter Streaming API endpoint");
        A.ensure((this.getSingleTupleExtractor() != null || this.getMultipleTupleExtractor() != null ? 1 : 0) != 0, (String)"Twitter extractor");
        String followParam = this.apiParams.get("follow");
        A.ensure((followParam != null && followParam.matches("^(\\d+,? ?)+$") ? 1 : 0) != 0, (String)"Site streaming endpoint must provide 'follow' param with value as comma separated numbers");
    }

    /*
     * WARNING - void declaration
     */
    protected Client getClient(BlockingQueue<String> tweetQueue) {
        HttpHosts hosts;
        StatusesFilterEndpoint endpoint;
        void var5_9;
        String string = this.endpointUrl.toLowerCase();
        int n = -1;
        switch (string.hashCode()) {
            case 2142153950: {
                if (!string.equals("/statuses/filter.json")) break;
                boolean bl = false;
                break;
            }
            case 916882919: {
                if (!string.equals("/statuses/firehose.json")) break;
                boolean bl = true;
                break;
            }
            case -1109618196: {
                if (!string.equals("/statuses/sample.json")) break;
                int n2 = 2;
                break;
            }
            case -352213540: {
                if (!string.equals("/user.json")) break;
                int n3 = 3;
                break;
            }
            case -1225031712: {
                if (!string.equals("/site.json")) break;
                int n4 = 4;
            }
        }
        switch (var5_9) {
            case 0: {
                endpoint = new StatusesFilterEndpoint();
                hosts = HttpHosts.STREAM_HOST;
                break;
            }
            case 1: {
                endpoint = new StatusesFirehoseEndpoint();
                hosts = HttpHosts.STREAM_HOST;
                break;
            }
            case 2: {
                endpoint = new StatusesSampleEndpoint();
                hosts = HttpHosts.STREAM_HOST;
                break;
            }
            case 3: {
                endpoint = new UserstreamEndpoint();
                hosts = HttpHosts.USERSTREAM_HOST;
                break;
            }
            case 4: {
                String follow = this.apiParams.remove("follow");
                ArrayList followers = Lists.newArrayList();
                for (String follower : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)follow)) {
                    followers.add(Long.valueOf(follower));
                }
                endpoint = new SitestreamEndpoint((List)followers);
                hosts = HttpHosts.SITESTREAM_HOST;
                break;
            }
            default: {
                endpoint = new DefaultStreamingEndpoint(this.endpointUrl, "GET", false);
                hosts = HttpHosts.STREAM_HOST;
            }
        }
        for (Map.Entry entry : this.apiParams.entrySet()) {
            endpoint.addPostParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return this.buildClient(tweetQueue, hosts, (StreamingEndpoint)endpoint);
    }

    protected Client buildClient(BlockingQueue<String> tweetQueue, HttpHosts hosts, StreamingEndpoint endpoint) {
        OAuth1 authentication = new OAuth1(this.oAuthSettings.getConsumerKey(), this.oAuthSettings.getConsumerSecret(), this.oAuthSettings.getAccessToken(), this.oAuthSettings.getAccessTokenSecret());
        ClientBuilder builder = new ClientBuilder().name("Ignite-Twitter-Client").hosts((Hosts)hosts).authentication((Authentication)authentication).endpoint(endpoint).processor((HosebirdMessageProcessor)new StringDelimitedProcessor(tweetQueue));
        return builder.build();
    }

    public void setApiParams(Map<String, String> apiParams) {
        this.apiParams = apiParams;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public void setBufferCapacity(Integer bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = threadsCount;
    }
}

