/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.ml.math;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.impls.matrix.SparseBlockDistributedMatrix;
import org.apache.ignite.ml.math.impls.matrix.SparseDistributedMatrix;
import org.apache.ignite.yardstick.ml.math.IgniteAbstractMatrixMulBenchmark;

public class IgniteSparseDistributedMatrixMul2Benchmark
extends IgniteAbstractMatrixMulBenchmark {
    @Override
    Matrix newMatrix(int rowSize, int colSize) {
        return new SparseDistributedMatrix(rowSize, colSize, 2001, 1002);
    }

    @Override
    public Matrix times(Matrix m1, Matrix m2) {
        return new OptimisedTimes(m1, m2).times();
    }

    private static class OptimisedTimes {
        private final Matrix m1;
        private final Matrix m2;

        OptimisedTimes(Matrix m1, Matrix m2) {
            this.m1 = m1;
            this.m2 = m2;
        }

        Matrix times() {
            Matrix m1Block = new SparseBlockDistributedMatrix(this.m1.rowSize(), this.m1.columnSize()).assign(this.m1);
            Matrix m2Block = new SparseBlockDistributedMatrix(this.m2.rowSize(), this.m2.columnSize()).assign(this.m2);
            Matrix m3Block = m1Block.times(m2Block);
            Matrix res = new SparseDistributedMatrix(m3Block.rowSize(), m3Block.columnSize(), 2001, 1002).assign(m3Block);
            m1Block.destroy();
            m2Block.destroy();
            m3Block.destroy();
            return res;
        }
    }
}

