/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.ml;

import java.util.concurrent.atomic.AtomicInteger;

public class DataChanger {
    private static final AtomicInteger changer = new AtomicInteger(0);

    public static double next() {
        return changer.incrementAndGet() % 17 + 1;
    }

    public static class Scale {
        private final double scale = DataChanger.next();

        public double[][] mutate(double[][] orig) {
            for (int i = 0; i < orig.length; ++i) {
                orig[i] = this.mutate(orig[i]);
            }
            return orig;
        }

        public double[] mutate(double[] orig) {
            int i = 0;
            while (i < orig.length) {
                int n = i++;
                orig[n] = orig[n] * this.scale;
            }
            return orig;
        }
    }
}

