/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteException;
import org.apache.ignite.yardstick.cache.jdbc.JdbcAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class RdbmsBenchmark
extends JdbcAbstractBenchmark {
    private long accRows;
    private long tellRows;
    private long branchRows;
    private AtomicLong cnt;
    private boolean isIgnite;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.isIgnite = ((Connection)this.conn.get()).getMetaData().getDatabaseProductName().equals("Apache Ignite");
        if (this.isIgnite) {
            this.clearCaches();
        } else {
            ((Connection)this.conn.get()).createStatement().execute("DROP TABLE if exists History;");
            ((Connection)this.conn.get()).createStatement().execute("CREATE TABLE if not exists History (id BIGINT, aid BIGINT, tid BIGINT, bid BIGINT, delta BIGINT);");
        }
        this.cnt = new AtomicLong();
        this.accRows = 1000L * (long)this.args.scaleFactor();
        this.tellRows = 10L * (long)this.args.scaleFactor();
        this.branchRows = 5L * (long)this.args.scaleFactor();
        this.fillTable("Accounts", this.accRows);
        this.fillTable("Tellers", this.tellRows);
        this.fillTable("Branches", this.branchRows);
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long aid = ThreadLocalRandom.current().nextLong(this.accRows);
        long bid = ThreadLocalRandom.current().nextLong(this.branchRows);
        long tid = ThreadLocalRandom.current().nextLong(this.tellRows);
        long delta = ThreadLocalRandom.current().nextLong(1000L);
        for (String query : this.getDbqueries()) {
            boolean done = false;
            query = query.replaceAll(":aid", Long.toString(aid));
            query = query.replaceAll(":bid", Long.toString(bid));
            query = query.replaceAll(":tid", Long.toString(tid));
            if ((query = query.replaceAll(":delta", Long.toString(delta))).contains(":id")) {
                query = query.replaceAll(":id", Long.toString(this.cnt.getAndIncrement()));
            }
            try {
                PreparedStatement stmt = ((Connection)this.conn.get()).prepareStatement(query);
                Throwable throwable = null;
                try {
                    if (this.isIgnite && query.startsWith("INSERT")) {
                        stmt.setLong(1, this.cnt.getAndIncrement());
                        stmt.setLong(2, tid);
                        stmt.setLong(3, bid);
                        stmt.setLong(4, aid);
                        stmt.setLong(5, delta);
                    }
                    while (!done) {
                        stmt.execute();
                        done = true;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stmt == null) continue;
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stmt.close();
                }
            }
            catch (Exception ignored) {
                BenchmarkUtils.println((String)("Failed to execute query " + query));
            }
        }
        return true;
    }

    private static PreparedStatement createUpsertStatement(Connection conn, String tblName) throws SQLException {
        switch (conn.getMetaData().getDatabaseProductName()) {
            case "H2": {
                return conn.prepareStatement("merge into " + tblName + " (id, val) values(?, ?)");
            }
            case "Apache Ignite": {
                return conn.prepareStatement("merge into \"" + tblName + '\"' + '.' + tblName + " (_key, val) values(?, ?)");
            }
            case "MySQL": {
                return conn.prepareStatement("insert into " + tblName + " (id, val) values(?, ?) on duplicate key " + "update val = ?");
            }
            case "PostgreSQL": {
                return conn.prepareStatement("insert into " + tblName + " (id, val) values(?, ?) on conflict(id) do " + "update set val = ?");
            }
        }
        throw new IgniteException("Unexpected database type [databaseProductName=" + conn.getMetaData().getDatabaseProductName() + ']');
    }

    private static void setUpsertStatementArgs(PreparedStatement stmt, long newKey, long newVal) throws SQLException {
        switch (stmt.getConnection().getMetaData().getDatabaseProductName()) {
            case "H2": {
                break;
            }
            case "Apache Ignite": {
                break;
            }
            case "MySQL": 
            case "PostgreSQL": {
                stmt.setLong(3, newVal);
                break;
            }
            default: {
                throw new IgniteException("Unexpected database type [databaseProductName=" + stmt.getConnection().getMetaData().getDatabaseProductName() + ']');
            }
        }
        stmt.setLong(1, newKey);
        stmt.setLong(2, newVal);
    }

    private void fillTable(String tblName, long rows) throws Exception {
        if (!this.isIgnite && this.args.schemaDefinition() == null) {
            return;
        }
        if (this.isIgnite) {
            this.startPreloadLogging(this.args.preloadLogsInterval());
        }
        try (PreparedStatement stmt = RdbmsBenchmark.createUpsertStatement((Connection)this.conn.get(), tblName);){
            for (long i = 0L; i < rows; ++i) {
                int newVal = RdbmsBenchmark.nextRandom(this.args.range());
                RdbmsBenchmark.setUpsertStatementArgs(stmt, i, newVal);
                stmt.execute();
                if (i % 1000L != 0L) continue;
                BenchmarkUtils.println((String)("Inserting " + i + "th value into " + tblName));
            }
        }
        this.stopPreloadLogging();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    private void clearCaches() {
        this.ignite().cache("Accounts").clear();
        this.ignite().cache("Tellers").clear();
        this.ignite().cache("Branches").clear();
        this.ignite().cache("History").clear();
    }
}

