/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.failover;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.yardstick.cache.failover.IgniteConsistencyException;
import org.apache.ignite.yardstick.cache.failover.IgniteFailoverAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteAtomicInvokeRetryBenchmark
extends IgniteFailoverAbstractBenchmark<String, Set> {
    private final ConcurrentMap<String, AtomicLong> nextValMap = new ConcurrentHashMap<String, AtomicLong>();
    private final ReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private volatile Exception ex;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    try {
                        int timeout = IgniteAtomicInvokeRetryBenchmark.this.args.cacheOperationTimeoutMillis();
                        int range = IgniteAtomicInvokeRetryBenchmark.this.args.range();
                        while (!Thread.currentThread().isInterrupted()) {
                            Thread.sleep(IgniteAtomicInvokeRetryBenchmark.this.args.cacheConsistencyCheckingPeriod() * 1000);
                            IgniteAtomicInvokeRetryBenchmark.this.rwl.writeLock().lock();
                            try {
                                String key;
                                BenchmarkUtils.println((String)"Start cache validation.");
                                long startTime = U.currentTimeMillis();
                                HashMap<String, Set> badCacheEntries = new HashMap<String, Set>();
                                for (Map.Entry e : IgniteAtomicInvokeRetryBenchmark.this.nextValMap.entrySet()) {
                                    key = (String)e.getKey();
                                    Set set = (Set)IgniteAtomicInvokeRetryBenchmark.this.cache.getAsync((Object)key).get((long)timeout);
                                    if (set != null && e.getValue() != null && Objects.equals(((AtomicLong)e.getValue()).get(), set.size())) continue;
                                    badCacheEntries.put(key, set);
                                }
                                if (!badCacheEntries.isEmpty()) {
                                    for (Map.Entry e : badCacheEntries.entrySet()) {
                                        key = (String)e.getKey();
                                        BenchmarkUtils.println((String)("Got unexpected set size [key='" + key + "', expSize=" + IgniteAtomicInvokeRetryBenchmark.this.nextValMap.get(key) + ", cacheVal=" + e.getValue() + "]"));
                                    }
                                    BenchmarkUtils.println((String)"Next values map contant:");
                                    for (Map.Entry e : IgniteAtomicInvokeRetryBenchmark.this.nextValMap.entrySet()) {
                                        BenchmarkUtils.println((String)("Map Entry [key=" + (String)e.getKey() + ", val=" + e.getValue() + "]"));
                                    }
                                    BenchmarkUtils.println((String)"Cache content:");
                                    for (int k2 = 0; k2 < range; ++k2) {
                                        String key2 = "key-" + k2;
                                        Object val = IgniteAtomicInvokeRetryBenchmark.this.cache.getAsync((Object)key2).get((long)timeout);
                                        if (val == null) continue;
                                        BenchmarkUtils.println((String)("Cache Entry [key=" + key2 + ", val=" + val + "]"));
                                    }
                                    throw new IgniteConsistencyException("Cache and local map are in inconsistent state [badKeys=" + badCacheEntries.keySet() + ']');
                                }
                                BenchmarkUtils.println((String)"Clearing all data.");
                                IgniteAtomicInvokeRetryBenchmark.this.cache.removeAllAsync().get((long)timeout);
                                IgniteAtomicInvokeRetryBenchmark.this.nextValMap.clear();
                                BenchmarkUtils.println((String)("Cache validation successfully finished in " + (U.currentTimeMillis() - startTime) / 1000L + " sec."));
                            }
                            finally {
                                IgniteAtomicInvokeRetryBenchmark.this.rwl.writeLock().unlock();
                            }
                        }
                    }
                    catch (Throwable e) {
                        IgniteAtomicInvokeRetryBenchmark.this.ex = new Exception(e);
                        BenchmarkUtils.println((String)("Got exception: " + e));
                        e.printStackTrace();
                        if (!(e instanceof Error)) break block11;
                        throw (Error)e;
                    }
                }
            }
        }, "cache-" + this.cacheName() + "-validator");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test(Map<Object, Object> ctx) throws Exception {
        int k = IgniteAtomicInvokeRetryBenchmark.nextRandom(this.args.range());
        String key = "key-" + k;
        this.rwl.readLock().lock();
        try {
            if (this.ex != null) {
                throw this.ex;
            }
            AtomicLong nextAtomicVal = this.nextValMap.putIfAbsent(key, new AtomicLong(1L));
            Long nextVal = 1L;
            if (nextAtomicVal != null) {
                nextVal = nextAtomicVal.incrementAndGet();
            }
            this.cache.invokeAsync((Object)key, (CacheEntryProcessor)new AddInSetEntryProcessor(), new Object[]{nextVal}).get((long)this.args.cacheOperationTimeoutMillis());
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (this.ex != null) {
            throw this.ex;
        }
        return true;
    }

    @Override
    protected String cacheName() {
        return "atomic-invoke-retry";
    }

    private static class AddInSetEntryProcessor
    implements CacheEntryProcessor<String, Set, Object> {
        private static final long serialVersionUID = 0L;

        private AddInSetEntryProcessor() {
        }

        public Object process(MutableEntry<String, Set> entry, Object ... arguments) throws EntryProcessorException {
            assert (!F.isEmpty((Object[])arguments));
            Object val = arguments[0];
            Set set = !entry.exists() ? new HashSet() : (Set)entry.getValue();
            set.add(val);
            entry.setValue(set);
            return null;
        }
    }
}

