/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public class IgniteScanQueryBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.loadCachesData();
    }

    @Override
    protected void loadCacheData(String cacheName) {
        this.loadSampleValues(cacheName, this.args.range());
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        int key = IgniteScanQueryBenchmark.nextRandom(this.args.range());
        ScanQuery qry = new ScanQuery();
        qry.setFilter((IgniteBiPredicate)new KeyFilter(key));
        IgniteCache cache = this.cacheForOperation().withKeepBinary();
        List res = cache.query((Query)qry).getAll();
        if (res.size() != 1) {
            throw new Exception("Invalid result size: " + res.size());
        }
        if ((Integer)((Cache.Entry)res.get(0)).getKey() != key) {
            throw new Exception("Invalid entry found [key=" + key + ", entryKey=" + ((Cache.Entry)res.get(0)).getKey() + ']');
        }
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("atomic");
    }

    static class KeyFilter
    implements IgniteBiPredicate<Integer, Object> {
        private final Integer key;

        public KeyFilter(Integer key) {
            this.key = key;
        }

        public boolean apply(Integer key, Object val) {
            return this.key.equals(key);
        }
    }
}

