/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Account;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class IgniteAccountTxAbstractBenchmark
extends IgniteCacheAbstractBenchmark {
    protected IgniteTransactions txs;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.txs = this.ignite().transactions();
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populating data...");
        long start = System.nanoTime();
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(this.cache.getName());){
            for (int i = 0; i < this.args.range() && !Thread.currentThread().isInterrupted(); ++i) {
                dataLdr.addData((Object)i, (Object)new Account(100000));
                if (i % 100000 != 0) continue;
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populated accounts: " + i));
            }
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Finished populating data in " + (System.nanoTime() - start) / 1000000L + " ms."));
    }

    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("tx");
    }
}

