/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.yardstick.IgniteNode;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class PreloadLogger
implements Runnable {
    private BenchmarkConfiguration cfg;
    private Collection<IgniteCache<Object, Object>> caches = new ArrayList<IgniteCache<Object, Object>>();
    private Map<String, Long> cntrs = new HashMap<String, Long>();
    private String strFmt;
    private ScheduledFuture<?> fut;

    public PreloadLogger(IgniteNode node, BenchmarkConfiguration cfg) {
        this.cfg = cfg;
        this.init(node);
    }

    @Override
    public void run() {
        this.printCachesStatistics();
    }

    public synchronized void printCachesStatistics() {
        for (IgniteCache<Object, Object> cache : this.caches) {
            try {
                this.printCacheStatistics(cache);
            }
            catch (Exception e) {
                BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Failed to print cache size [cache=" + cache.getName() + ", msg=" + e.getMessage() + "]"));
            }
        }
    }

    private void printCacheStatistics(IgniteCache<Object, Object> cache) {
        String cacheName = cache.getName();
        long cacheSize = cache.sizeLong(new CachePeekMode[0]);
        long recentlyLoaded = cacheSize - this.cntrs.get(cacheName);
        String recLoaded = recentlyLoaded == 0L ? String.valueOf(recentlyLoaded) : "+" + recentlyLoaded;
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)String.format(this.strFmt, cacheName, cacheSize, recLoaded));
        this.cntrs.put(cacheName, cacheSize);
    }

    private void init(IgniteNode node) {
        int longestName = 0;
        for (String cacheName : node.ignite().cacheNames()) {
            IgniteCache cache = node.ignite().cache(cacheName);
            this.caches.add((IgniteCache<Object, Object>)cache);
            this.cntrs.put(cache.getName(), 0L);
            longestName = Math.max(cache.getName().length(), longestName);
        }
        this.strFmt = "Preload:%-" + (longestName + 4) + "s%-8d\t(%s)";
    }

    public void setFuture(ScheduledFuture<?> fut) {
        this.fut = fut;
    }

    public void stopAndPrintStatistics() {
        try {
            if (this.fut != null && !this.fut.cancel(true)) {
                U.sleep((long)200L);
                if (!this.fut.cancel(true)) {
                    BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"Failed to cancel Preload logger.");
                    return;
                }
            }
            this.printCachesStatistics();
        }
        catch (Exception e) {
            BenchmarkUtils.error((String)"Failed to stop Preload logger.", (Throwable)e);
        }
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"Preload logger was stopped.");
    }
}

