/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.failover.never;

import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.failover.FailoverContext;
import org.apache.ignite.spi.failover.FailoverSpi;
import org.apache.ignite.spi.failover.never.NeverFailoverSpiMBean;

@IgniteSpiMultipleInstancesSupport(value=true)
public class NeverFailoverSpi
extends IgniteSpiAdapter
implements FailoverSpi {
    @LoggerResource
    private IgniteLogger log;

    @Override
    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        this.startStopwatch();
        this.registerMBean(igniteInstanceName, new NeverFailoverSpiMBeanImpl(this), NeverFailoverSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    public ClusterNode failover(FailoverContext ctx, List<ClusterNode> top) {
        U.warn(this.log, "Returning 'null' node for failed job (failover will not happen) [job=" + ctx.getJobResult().getJob() + ", task=" + ctx.getTaskSession().getTaskName() + ", sessionId=" + ctx.getTaskSession().getId() + ']');
        return null;
    }

    @Override
    public NeverFailoverSpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(NeverFailoverSpi.class, this);
    }

    private class NeverFailoverSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements NeverFailoverSpiMBean {
        NeverFailoverSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }
    }
}

