/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;

@GridToStringExclude
public class GridSpinBusyLock {
    private final GridSpinReadWriteLock lock = new GridSpinReadWriteLock();

    public boolean enterBusy() {
        return !this.lock.writeLockedByCurrentThread() && this.lock.tryReadLock();
    }

    public boolean blockedByCurrentThread() {
        return this.lock.writeLockedByCurrentThread();
    }

    public void leaveBusy() {
        this.lock.readUnlock();
    }

    public void block() {
        this.lock.writeLock();
    }

    public boolean tryBlock(long millis) throws InterruptedException {
        return this.lock.tryWriteLock(millis, TimeUnit.MILLISECONDS);
    }

    public void unblock() {
        this.lock.writeUnlock();
    }
}

