/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileMap;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class IgfsFileInfo
extends IgfsEntryInfo
implements Binarylizable {
    private static final long serialVersionUID = 0L;
    private long len;
    private int blockSize;
    private IgniteUuid lockId;
    private IgniteUuid affKey;
    private IgfsFileMap fileMap;
    private boolean evictExclude;

    public IgfsFileInfo() {
    }

    @Override
    public IgfsFileInfo length(long len) {
        IgfsFileInfo res = this.copy();
        res.len = len;
        return res;
    }

    @Override
    public IgfsEntryInfo listing(@Nullable Map<String, IgfsListingEntry> listing) {
        throw new UnsupportedOperationException("listing");
    }

    @Override
    public IgfsFileInfo lock(IgniteUuid lockId) {
        assert (lockId != null);
        assert (this.lockId == null);
        IgfsFileInfo res = this.copy();
        res.lockId = lockId;
        return res;
    }

    @Override
    public IgfsFileInfo unlock(long modificationTime) {
        IgfsFileInfo res = this.copy();
        res.lockId = null;
        res.modificationTime = modificationTime;
        return res;
    }

    @Override
    public IgfsFileInfo fileMap(IgfsFileMap fileMap) {
        IgfsFileInfo res = this.copy();
        res.fileMap = fileMap;
        return res;
    }

    @Override
    protected IgfsFileInfo copy() {
        return new IgfsFileInfo(this.id, this.blockSize, this.len, this.affKey, this.props, this.fileMap, this.lockId, this.accessTime, this.modificationTime, this.evictExclude);
    }

    IgfsFileInfo(IgniteUuid id, int blockSize, long len, @Nullable IgniteUuid affKey, @Nullable Map<String, String> props, @Nullable IgfsFileMap fileMap, @Nullable IgniteUuid lockId, long accessTime, long modificationTime, boolean evictExclude) {
        super(id, props, accessTime, modificationTime);
        this.len = len;
        this.blockSize = blockSize;
        this.affKey = affKey;
        if (fileMap == null) {
            fileMap = new IgfsFileMap();
        }
        this.fileMap = fileMap;
        this.lockId = lockId;
        this.evictExclude = evictExclude;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public long length() {
        return this.len;
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public long blocksCount() {
        return (this.len + (long)this.blockSize() - 1L) / (long)this.blockSize();
    }

    @Override
    public Map<String, IgfsListingEntry> listing() {
        return Collections.emptyMap();
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean hasChild(String name) {
        return false;
    }

    @Override
    public boolean hasChild(String name, IgniteUuid expId) {
        return false;
    }

    @Override
    @Nullable
    public IgniteUuid affinityKey() {
        return this.affKey;
    }

    @Override
    public IgfsFileMap fileMap() {
        return this.fileMap;
    }

    @Override
    @Nullable
    public IgniteUuid lockId() {
        return this.lockId;
    }

    @Override
    public boolean evictExclude() {
        return this.evictExclude;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.blockSize);
        out.writeLong(this.len);
        U.writeGridUuid(out, this.lockId);
        U.writeGridUuid(out, this.affKey);
        out.writeObject(this.fileMap);
        out.writeBoolean(this.evictExclude);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.blockSize = in.readInt();
        this.len = in.readLong();
        this.lockId = U.readGridUuid(in);
        this.affKey = U.readGridUuid(in);
        this.fileMap = (IgfsFileMap)in.readObject();
        this.evictExclude = in.readBoolean();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        this.writeBinary(out);
        out.writeInt(this.blockSize);
        out.writeLong(this.len);
        BinaryUtils.writeIgniteUuid(out, this.lockId);
        BinaryUtils.writeIgniteUuid(out, this.affKey);
        out.writeObject(this.fileMap);
        out.writeBoolean(this.evictExclude);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.readBinary(in);
        this.blockSize = in.readInt();
        this.len = in.readLong();
        this.lockId = BinaryUtils.readIgniteUuid(in);
        this.affKey = BinaryUtils.readIgniteUuid(in);
        this.fileMap = (IgfsFileMap)in.readObject();
        this.evictExclude = in.readBoolean();
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.blockSize ^ (int)(this.len ^ this.len >>> 32) ^ (this.props == null ? 0 : this.props.hashCode()) ^ (this.lockId == null ? 0 : this.lockId.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IgfsFileInfo that = (IgfsFileInfo)obj;
        return this.id.equals(that.id) && this.blockSize == that.blockSize && this.len == that.len && F.eq(this.affKey, that.affKey) && F.eq(this.props, that.props) && F.eq(this.lockId, that.lockId);
    }

    @Override
    public String toString() {
        return S.toString(IgfsFileInfo.class, this);
    }
}

