/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheRemovable;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class AtomicDataStructureProxy<V extends AtomicDataStructureValue>
implements GridCacheRemovable,
IgniteChangeGlobalStateSupport {
    protected IgniteLogger log;
    protected volatile boolean rmvd;
    private volatile GridFutureAdapter<Void> suspendFut;
    private boolean rmvCheck;
    protected String name;
    protected GridCacheInternalKey key;
    protected IgniteInternalCache<GridCacheInternalKey, V> cacheView;
    protected volatile GridCacheContext<GridCacheInternalKey, V> ctx;

    public AtomicDataStructureProxy() {
    }

    public AtomicDataStructureProxy(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, V> cacheView) {
        assert (key != null);
        assert (cacheView != null);
        this.ctx = cacheView.context();
        this.key = key;
        this.cacheView = cacheView;
        this.name = name;
        this.log = this.ctx.logger(this.getClass());
    }

    public String name() {
        return this.name;
    }

    public GridCacheInternalKey key() {
        return this.key;
    }

    public boolean removed() {
        return this.rmvd;
    }

    protected void checkRemoved() throws IllegalStateException {
        if (this.rmvd) {
            throw this.removedError();
        }
        GridFutureAdapter<Void> suspendFut0 = this.suspendFut;
        if (suspendFut0 != null && !suspendFut0.isDone()) {
            throw this.suspendedError();
        }
        if (this.rmvCheck) {
            try {
                this.rmvd = this.cacheView.get(this.key) == null;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            this.rmvCheck = false;
            if (this.rmvd) {
                this.ctx.kernalContext().dataStructures().onRemoved(this.key, this);
                throw this.removedError();
            }
        }
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Sequence was removed from cache: " + this.name);
    }

    private IllegalStateException suspendedError() {
        throw new IgniteCacheRestartingException(new IgniteFutureImpl<Void>(this.suspendFut), "Underlying cache is restarting: " + this.ctx.name());
    }

    @Override
    public boolean onRemoved() {
        this.rmvd = true;
        return true;
    }

    @Override
    public void needCheckNotRemoved() {
        this.rmvCheck = true;
    }

    @Override
    public void suspend() {
        this.suspendFut = new GridFutureAdapter();
    }

    @Override
    public void restart(IgniteInternalCache cache) {
        this.invalidateLocalState();
        this.cacheView = cache;
        this.ctx = cache.context();
        this.rmvCheck = true;
        this.suspendFut.onDone();
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        this.ctx = kctx.cache().context().cacheContext(this.ctx.cacheId());
        this.cacheView = this.ctx.cache();
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
    }

    protected void invalidateLocalState() {
    }
}

