/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.function.BiConsumer;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.mem.IgniteOutOfMemoryException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.LoadedPagesMap;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.ReplaceCandidate;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class RobinHoodBackwardShiftHashMap
implements LoadedPagesMap {
    private static final float LOAD_FACTOR = IgniteSystemProperties.getFloat("IGNITE_LONG_LONG_HASH_MAP_LOAD_FACTOR", 2.5f);
    private static final int MAPSIZE_SIZE = 4;
    private static final int CELL_PADDING = 4;
    private static final int MAPSIZE_PADDING = 4;
    private static final int MAPSIZE_OFFSET = 0;
    private static final int IDEAL_BUCKET_SIZE = 4;
    private static final int IDEAL_BUCKET_OFFSET = 0;
    private static final int GRP_ID_SIZE = 4;
    private static final int GRP_ID_OFFSET = 4;
    private static final int PAGE_ID_SIZE = 8;
    private static final int PAGE_ID_OFFSET = 8;
    private static final int VALUE_SIZE = 8;
    private static final int VALUE_OFFSET = 16;
    private static final int VERSION_SIZE = 4;
    private static final int VERSION_OFFSET = 24;
    private static final long EMPTY_PAGE_ID = 0L;
    private static final int EMPTY_CACHE_GRP_ID = 0;
    private static final int BYTES_PER_CELL = 32;
    private final int numBuckets;
    private long baseAddr;

    public static long requiredMemory(long elementsCnt) {
        float loadFactor = LOAD_FACTOR;
        assert (loadFactor != 0.0f);
        return RobinHoodBackwardShiftHashMap.requiredMemoryByBuckets((long)((float)elementsCnt * loadFactor));
    }

    static long requiredMemoryByBuckets(long numBuckets) {
        return numBuckets * 32L + 4L + 4L;
    }

    public RobinHoodBackwardShiftHashMap(long baseAddr, long size) {
        this.numBuckets = (int)((size - 4L - 4L) / 32L);
        this.baseAddr = baseAddr;
        GridUnsafe.setMemory(baseAddr, size, (byte)0);
    }

    private long entryBase(int idx) {
        assert (idx >= 0 && idx < this.numBuckets) : "idx=" + idx + ", numBuckets=" + this.numBuckets;
        return this.baseAddr + 4L + 4L + (long)idx * 32L;
    }

    @Override
    public long get(int grpId, long pageId, int reqVer, long absent, long outdated) {
        assert (grpId != 0);
        int idxInit = U.safeAbs(FullPageId.hashCode(grpId, pageId)) % this.numBuckets;
        for (int i = 0; i < this.numBuckets; ++i) {
            int idxCurr = (idxInit + i) % this.numBuckets;
            long base = this.entryBase(idxCurr);
            int distanceFromInit = this.distance(idxCurr, idxInit);
            int curGrpId = this.getGrpId(base);
            long curPageId = this.getPageId(base);
            int dibCurEntry = this.distance(idxCurr, this.getIdealBucket(base));
            if (this.isEmpty(curGrpId, curPageId)) {
                return absent;
            }
            if (curGrpId == grpId && curPageId == pageId) {
                long actualVer = this.getVersion(base);
                boolean freshVal = actualVer >= (long)reqVer;
                return freshVal ? this.getValue(base) : outdated;
            }
            if (dibCurEntry >= distanceFromInit) continue;
            return absent;
        }
        return absent;
    }

    @Override
    public void put(int grpId, long pageId, long val, int ver) {
        assert (grpId != 0);
        int idxInit = U.safeAbs(FullPageId.hashCode(grpId, pageId)) % this.numBuckets;
        int swapCnt = 0;
        int grpIdToInsert = grpId;
        long pageIdToInsert = pageId;
        long valToInsert = val;
        int verToInsert = ver;
        long idxIdealToInsert = idxInit;
        for (int i = 0; i < this.numBuckets; ++i) {
            int idxCurr = (idxInit + i) % this.numBuckets;
            long base = this.entryBase(idxCurr);
            int dibEntryToInsert = this.distance(idxCurr, idxInit);
            int curGrpId = this.getGrpId(base);
            long curPageId = this.getPageId(base);
            int curIdealBucket = this.getIdealBucket(base);
            long curVal = this.getValue(base);
            int curVer = this.getVersion(base);
            int dibCurEntry = this.distance(idxCurr, curIdealBucket);
            if (this.isEmpty(curGrpId, curPageId)) {
                this.setCellValue(base, idxIdealToInsert, grpIdToInsert, pageIdToInsert, valToInsert, verToInsert);
                this.setSize(this.size() + 1);
                return;
            }
            if (curGrpId == grpIdToInsert && curPageId == pageIdToInsert) {
                if (swapCnt != 0) {
                    throw new IllegalStateException("Swapped " + swapCnt + " times. Entry: " + this.dumpEntry(idxCurr));
                }
                this.setValue(base, valToInsert);
                return;
            }
            if (dibCurEntry >= dibEntryToInsert) continue;
            this.setCellValue(base, idxIdealToInsert, grpIdToInsert, pageIdToInsert, valToInsert, verToInsert);
            idxIdealToInsert = curIdealBucket;
            pageIdToInsert = curPageId;
            grpIdToInsert = curGrpId;
            valToInsert = curVal;
            verToInsert = curVer;
            ++swapCnt;
        }
        throw new IgniteOutOfMemoryException("No room for a new key");
    }

    @Override
    public boolean remove(int grpId, long pageId) {
        assert (grpId != 0);
        int idxInit = U.safeAbs(FullPageId.hashCode(grpId, pageId)) % this.numBuckets;
        int idxEqualValFound = -1;
        for (int i = 0; i < this.numBuckets; ++i) {
            int idxCurr = (idxInit + i) % this.numBuckets;
            long base = this.entryBase(idxCurr);
            int dibEntryToInsert = this.distance(idxCurr, idxInit);
            int curGrpId = this.getGrpId(base);
            long curPageId = this.getPageId(base);
            int curIdealBucket = this.getIdealBucket(base);
            int dibCurEntry = this.distance(idxCurr, curIdealBucket);
            if (this.isEmpty(curGrpId, curPageId)) {
                return false;
            }
            if (curGrpId == grpId && curPageId == pageId) {
                idxEqualValFound = idxCurr;
                break;
            }
            if (dibCurEntry >= dibEntryToInsert) continue;
            return false;
        }
        this.setSize(this.size() - 1);
        this.doBackwardShift(idxEqualValFound);
        return true;
    }

    private void doBackwardShift(int idxRmv) {
        assert (idxRmv >= 0);
        for (int i = 0; i < this.numBuckets - 1; ++i) {
            int idxCurr = (idxRmv + i) % this.numBuckets;
            int idxNext = (idxRmv + i + 1) % this.numBuckets;
            long baseCurr = this.entryBase(idxCurr);
            long baseNext = this.entryBase(idxNext);
            int nextGrpId = this.getGrpId(baseNext);
            long nextPageId = this.getPageId(baseNext);
            int nextIdealBucket = this.getIdealBucket(baseNext);
            int nextEntryVer = this.getVersion(baseNext);
            if (this.isEmpty(nextGrpId, nextPageId) || this.distance(idxNext, nextIdealBucket) == 0) {
                this.setEmpty(baseCurr);
                return;
            }
            this.setCellValue(baseCurr, nextIdealBucket, nextGrpId, nextPageId, this.getValue(baseNext), nextEntryVer);
        }
        int lastShiftedIdx = (idxRmv - 1) % this.numBuckets;
        if (lastShiftedIdx < 0) {
            lastShiftedIdx += this.numBuckets;
        }
        this.setEmpty(this.entryBase(lastShiftedIdx));
    }

    @Override
    public ReplaceCandidate getNearestAt(int idxStart) {
        for (int i = 0; i < this.numBuckets; ++i) {
            int idxCurr = (idxStart + i) % this.numBuckets;
            if (this.isEmptyAt(idxCurr)) continue;
            long base = this.entryBase(idxCurr);
            return new ReplaceCandidate(this.getVersion(base), this.getValue(base), this.getFullPageId(base));
        }
        return null;
    }

    private boolean isEmptyAt(int idx) {
        long base = this.entryBase(idx);
        return this.isEmpty(this.getGrpId(base), this.getPageId(base));
    }

    @Override
    public long refresh(int grpId, long pageId, int ver) {
        assert (grpId != 0);
        int idxInit = U.safeAbs(FullPageId.hashCode(grpId, pageId)) % this.numBuckets;
        for (int i = 0; i < this.numBuckets; ++i) {
            int idxCurr = (idxInit + i) % this.numBuckets;
            long base = this.entryBase(idxCurr);
            int distanceFromInit = this.distance(idxCurr, idxInit);
            int curGrpId = this.getGrpId(base);
            long curPageId = this.getPageId(base);
            int curIdealBucket = this.getIdealBucket(base);
            int dibCurEntry = this.distance(idxCurr, curIdealBucket);
            if (this.isEmpty(curGrpId, curPageId)) break;
            if (curGrpId == grpId && curPageId == pageId) {
                boolean freshVal;
                long actualVer = this.getVersion(base);
                boolean bl = freshVal = actualVer >= (long)ver;
                if (freshVal) {
                    throw new IllegalArgumentException("Fresh element found at " + this.dumpEntry(idxCurr) + " during search of cell to refresh. " + "Refresh should be called for existent outdated element. ");
                }
                this.setVersion(base, ver);
                return this.getValue(base);
            }
            if (dibCurEntry < distanceFromInit) break;
        }
        throw new IllegalArgumentException("Element not found group ID: " + grpId + ", page ID: " + pageId + " during search of cell to refresh. Refresh should be called for existent outdated element. ");
    }

    @Override
    public GridLongList removeIf(int startIdxToClear, int endIdxToClear, LoadedPagesMap.KeyPredicate keyPred) {
        assert (endIdxToClear >= startIdxToClear) : "Start and end indexes are not consistent: {" + startIdxToClear + ", " + endIdxToClear + "}";
        int sz = endIdxToClear - startIdxToClear;
        GridLongList list = new GridLongList(sz);
        for (int idx = startIdxToClear; idx < endIdxToClear; ++idx) {
            long pageId;
            long base = this.entryBase(idx);
            int grpId = this.getGrpId(base);
            if (this.isEmpty(grpId, pageId = this.getPageId(base)) || !keyPred.test(grpId, pageId)) continue;
            long valAt = this.getValue(base);
            this.setSize(this.size() - 1);
            this.doBackwardShift(idx);
            list.add(valAt);
            --idx;
        }
        return list;
    }

    @Override
    public int capacity() {
        return this.numBuckets;
    }

    private int distance(int curr, int baseIdx) {
        int diff = curr - baseIdx;
        if (diff < 0) {
            return diff + this.numBuckets;
        }
        return diff;
    }

    private boolean isEmpty(int grpId, long pageId) {
        return pageId == 0L && grpId == 0;
    }

    private void setEmpty(long addr) {
        this.setPageId(addr, 0L);
        this.setGrpId(addr, 0);
        this.setValue(addr, 0L);
        this.setIdealBucket(addr, 0L);
        this.setVersion(addr, 0);
    }

    private void setIdealBucket(long base, long idxIdeal) {
        assert (idxIdeal >= 0L && idxIdeal < (long)this.numBuckets);
        GridUnsafe.putLong(base + 0L, idxIdeal);
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < this.numBuckets; ++idx) {
            this.dumpEntry(sb, idx);
        }
        return sb.toString();
    }

    private String dumpEntry(int idx) {
        StringBuilder sb = new StringBuilder();
        this.dumpEntry(sb, idx);
        return sb.toString();
    }

    private void dumpEntry(StringBuilder sb, int idx) {
        long base = this.entryBase(idx);
        int curGrpId = this.getGrpId(base);
        long curPageId = this.getPageId(base);
        long curVal = this.getValue(base);
        long ver = this.getVersion(base);
        sb.append("slot [").append(idx).append("]:");
        if (this.isEmpty(curGrpId, curPageId)) {
            sb.append("Empty: ");
        }
        sb.append("i.buc=").append(this.getIdealBucket(base)).append(",");
        sb.append("(grp=").append(curGrpId).append(",");
        sb.append("page=").append(curPageId).append(")");
        sb.append("->");
        sb.append("(val=").append(curVal).append(",");
        sb.append("ver=").append(ver).append(")");
        sb.append("\n");
    }

    private void setCellValue(long base, long idealBucket, int grpId, long pageId, long val, int ver) {
        this.setIdealBucket(base, idealBucket);
        this.setGrpId(base, grpId);
        this.setPageId(base, pageId);
        this.setValue(base, val);
        this.setVersion(base, ver);
    }

    private int getIdealBucket(long base) {
        return GridUnsafe.getInt(base + 0L);
    }

    private long getPageId(long base) {
        return GridUnsafe.getLong(base + 8L);
    }

    private void setPageId(long base, long pageId) {
        GridUnsafe.putLong(base + 8L, pageId);
    }

    private int getGrpId(long base) {
        return GridUnsafe.getInt(base + 4L);
    }

    private void setGrpId(long base, int grpId) {
        GridUnsafe.putInt(base + 4L, grpId);
    }

    private long getValue(long base) {
        return GridUnsafe.getLong(base + 16L);
    }

    private void setValue(long base, long val) {
        GridUnsafe.putLong(base + 16L, val);
    }

    private int getVersion(long base) {
        return GridUnsafe.getInt(base + 24L);
    }

    private void setVersion(long base, int ver) {
        GridUnsafe.putInt(base + 24L, ver);
    }

    @Override
    public final int size() {
        return GridUnsafe.getInt(this.baseAddr + 0L);
    }

    private void setSize(int sz) {
        GridUnsafe.putInt(this.baseAddr + 0L, sz);
    }

    @Override
    public void forEach(BiConsumer<FullPageId, Long> act) {
        for (int i = 0; i < this.numBuckets; ++i) {
            if (this.isEmptyAt(i)) continue;
            long base = this.entryBase(i);
            act.accept(this.getFullPageId(base), this.getValue(base));
        }
    }

    @NotNull
    private FullPageId getFullPageId(long base) {
        return new FullPageId(this.getPageId(base), this.getGrpId(base));
    }
}

