/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.EvictionContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridDhtPartitionsEvictor {
    private static final int DEFAULT_SHOW_EVICTION_PROGRESS_FREQ_MS = 120000;
    private static final String SHOW_EVICTION_PROGRESS_FREQ = "SHOW_EVICTION_PROGRESS_FREQ";
    private final GridCacheSharedContext<?, ?> ctx;
    private final CacheGroupContext grp;
    private final IgniteLogger log;
    private final Object mux = new Object();
    private final DeduplicationQueue<Integer, GridDhtLocalPartition> evictionQueue = new DeduplicationQueue<Integer, GridDhtLocalPartition>(GridDhtLocalPartition::id);
    private boolean evictionRunning;
    private volatile boolean stop;
    private volatile GridFutureAdapter<Boolean> evictionFut;
    private final long evictionProgressFreqMs = IgniteSystemProperties.getLong("SHOW_EVICTION_PROGRESS_FREQ", 120000L);
    private long nextShowProgressTime;

    public GridDhtPartitionsEvictor(CacheGroupContext grp) {
        assert (grp != null);
        this.grp = grp;
        this.ctx = grp.shared();
        this.log = this.ctx.logger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictPartitionAsync(GridDhtLocalPartition part) {
        if (this.stop) {
            return;
        }
        boolean added = this.evictionQueue.offer(part);
        if (!added) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (!this.evictionRunning) {
                this.nextShowProgressTime = U.currentTimeMillis() + this.evictionProgressFreqMs;
                this.scheduleNextPartitionEviction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stop = true;
        Object object = this.mux;
        synchronized (object) {
            block6: {
                GridFutureAdapter<Boolean> evictionFut0 = this.evictionFut;
                if (evictionFut0 != null) {
                    try {
                        evictionFut0.get();
                    }
                    catch (IgniteCheckedException e) {
                        if (!this.log.isDebugEnabled()) break block6;
                        this.log.warning("Failed to await partition eviction during stopping", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextPartitionEviction() {
        if (this.stop) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            GridDhtLocalPartition next = this.evictionQueue.poll();
            if (next != null) {
                this.showProgress();
                this.evictionFut = new GridFutureAdapter();
                this.ctx.kernalContext().closure().callLocalSafe(new PartitionEvictionTask(next, () -> this.stop), true);
            } else {
                this.evictionRunning = false;
            }
        }
    }

    private void showProgress() {
        if (U.currentTimeMillis() >= this.nextShowProgressTime) {
            int size = this.evictionQueue.size() + 1;
            if (this.log.isInfoEnabled()) {
                this.log.info("Eviction in progress [grp=" + this.grp.cacheOrGroupName() + ", remainingPartsCnt=" + size + "]");
            }
            this.nextShowProgressTime = U.currentTimeMillis() + this.evictionProgressFreqMs;
        }
    }

    private static class DeduplicationQueue<K, V> {
        private final Queue<V> queue;
        private final Set<K> uniqueItems;
        private final Function<V, K> keyMappingFunction;

        public DeduplicationQueue(Function<V, K> keyExtractor) {
            this.keyMappingFunction = keyExtractor;
            this.queue = new LinkedBlockingQueue<V>();
            this.uniqueItems = new GridConcurrentHashSet<K>();
        }

        public boolean offer(V item) {
            K key = this.keyMappingFunction.apply(item);
            if (this.uniqueItems.add(key)) {
                this.queue.offer(item);
                return true;
            }
            return false;
        }

        public V poll() {
            V item = this.queue.poll();
            if (item != null) {
                K key = this.keyMappingFunction.apply(item);
                this.uniqueItems.remove(key);
            }
            return item;
        }

        public int size() {
            return this.queue.size();
        }
    }

    private class PartitionEvictionTask
    implements Callable<Boolean> {
        private final GridDhtLocalPartition part;
        private final EvictionContext evictionCtx;

        public PartitionEvictionTask(GridDhtLocalPartition part, EvictionContext evictionCtx) {
            this.part = part;
            this.evictionCtx = evictionCtx;
        }

        @Override
        public Boolean call() throws Exception {
            if (GridDhtPartitionsEvictor.this.stop) {
                GridDhtPartitionsEvictor.this.evictionFut.onDone();
                return false;
            }
            try {
                boolean success = this.part.tryClear(this.evictionCtx);
                if (success) {
                    if (this.part.state() == GridDhtPartitionState.EVICTED && this.part.markForDestroy()) {
                        this.part.destroy();
                    }
                } else {
                    GridDhtPartitionsEvictor.this.evictionQueue.offer(this.part);
                }
                GridDhtPartitionsEvictor.this.evictionFut.onDone();
                GridDhtPartitionsEvictor.this.scheduleNextPartitionEviction();
                return true;
            }
            catch (Throwable ex) {
                GridDhtPartitionsEvictor.this.evictionFut.onDone(ex);
                if (GridDhtPartitionsEvictor.this.ctx.kernalContext().isStopping()) {
                    LT.warn(GridDhtPartitionsEvictor.this.log, ex, "Partition eviction failed (current node is stopping).", false, true);
                } else {
                    LT.error(GridDhtPartitionsEvictor.this.log, ex, "Partition eviction failed, this can cause grid hang.");
                }
                return false;
            }
        }
    }
}

