/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.net.InetSocketAddress;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.client.SslProtocol;
import org.apache.ignite.configuration.ClientConfiguration;

final class ClientChannelConfiguration {
    private InetSocketAddress addr;
    private SslMode sslMode;
    private boolean tcpNoDelay;
    private int timeout;
    private int sndBufSize;
    private int rcvBufSize;
    private String sslClientCertKeyStorePath;
    private String sslClientCertKeyStoreType;
    private String sslClientCertKeyStorePwd;
    private String sslTrustCertKeyStorePath;
    private String sslTrustCertKeyStoreType;
    private String sslTrustCertKeyStorePwd;
    private String sslKeyAlgorithm;
    private SslProtocol sslProto;
    private boolean sslTrustAll;
    private Factory<SSLContext> sslCtxFactory;
    private String userName;
    private String userPwd;

    ClientChannelConfiguration(ClientConfiguration cfg) {
        this.sslMode = cfg.getSslMode();
        this.tcpNoDelay = cfg.isTcpNoDelay();
        this.timeout = cfg.getTimeout();
        this.sndBufSize = cfg.getSendBufferSize();
        this.rcvBufSize = cfg.getReceiveBufferSize();
        this.sslClientCertKeyStorePath = cfg.getSslClientCertificateKeyStorePath();
        this.sslClientCertKeyStoreType = cfg.getSslClientCertificateKeyStoreType();
        this.sslClientCertKeyStorePwd = cfg.getSslClientCertificateKeyStorePassword();
        this.sslTrustCertKeyStorePath = cfg.getSslTrustCertificateKeyStorePath();
        this.sslTrustCertKeyStoreType = cfg.getSslTrustCertificateKeyStoreType();
        this.sslTrustCertKeyStorePwd = cfg.getSslTrustCertificateKeyStorePassword();
        this.sslKeyAlgorithm = cfg.getSslKeyAlgorithm();
        this.sslProto = cfg.getSslProtocol();
        this.sslTrustAll = cfg.isSslTrustAll();
        this.sslCtxFactory = cfg.getSslContextFactory();
        this.userName = cfg.getUserName();
        this.userPwd = cfg.getUserPassword();
    }

    public InetSocketAddress getAddress() {
        return this.addr;
    }

    public ClientChannelConfiguration setAddress(InetSocketAddress newVal) {
        this.addr = newVal;
        return this;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getSendBufferSize() {
        return this.sndBufSize;
    }

    public int getReceiveBufferSize() {
        return this.rcvBufSize;
    }

    public String getSslClientCertificateKeyStorePath() {
        return this.sslClientCertKeyStorePath;
    }

    public String getSslClientCertificateKeyStoreType() {
        return this.sslClientCertKeyStoreType;
    }

    public String getSslClientCertificateKeyStorePassword() {
        return this.sslClientCertKeyStorePwd;
    }

    public String getSslTrustCertificateKeyStorePath() {
        return this.sslTrustCertKeyStorePath;
    }

    public String getSslTrustCertificateKeyStoreType() {
        return this.sslTrustCertKeyStoreType;
    }

    public String getSslTrustCertificateKeyStorePassword() {
        return this.sslTrustCertKeyStorePwd;
    }

    public String getSslKeyAlgorithm() {
        return this.sslKeyAlgorithm;
    }

    public SslProtocol getSslProtocol() {
        return this.sslProto;
    }

    public boolean isSslTrustAll() {
        return this.sslTrustAll;
    }

    public Factory<SSLContext> getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPwd;
    }
}

