/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs;

import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.igfs.IgfsBaseBlockKey;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsGroupDataBlocksKeyMapper
extends GridCacheDefaultAffinityKeyMapper {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_GRP_SIZE = 1024;
    private int grpSize = 1024;

    public IgfsGroupDataBlocksKeyMapper() {
    }

    public IgfsGroupDataBlocksKeyMapper(int grpSize) {
        A.ensure(grpSize >= 1, "grpSize >= 1");
        this.grpSize = grpSize;
    }

    @Override
    public Object affinityKey(Object key) {
        if (key instanceof IgfsBaseBlockKey) {
            IgfsBaseBlockKey blockKey = (IgfsBaseBlockKey)key;
            IgniteUuid affKey = blockKey.affinityKey();
            if (affKey != null) {
                return affKey;
            }
            long grpId = blockKey.blockId() / (long)this.grpSize;
            return blockKey.fileHash() + (int)(grpId ^ grpId >>> 32);
        }
        return super.affinityKey(key);
    }

    public int getGroupSize() {
        return this.grpSize;
    }

    public IgfsGroupDataBlocksKeyMapper setGroupSize(int grpSize) {
        this.grpSize = grpSize;
        return this;
    }

    public String toString() {
        return S.toString(IgfsGroupDataBlocksKeyMapper.class, this);
    }
}

