/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.storm;

import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.stream.StreamAdapter;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;

public class StormStreamer<K, V>
extends StreamAdapter<Tuple, K, V>
implements IRichBolt {
    private static final long DFLT_FLUSH_FREQ = 10000L;
    private static final String DFLT_TUPLE_FIELD = "ignite";
    private IgniteLogger log;
    private String igniteTupleField = "ignite";
    private long autoFlushFrequency = 10000L;
    private boolean allowOverwrite = false;
    private static volatile boolean stopped = true;
    private OutputCollector collector;
    private static String igniteConfigFile;
    private static String cacheName;

    public String getIgniteTupleField() {
        return this.igniteTupleField;
    }

    public void setIgniteTupleField(String igniteTupleField) {
        this.igniteTupleField = igniteTupleField;
    }

    public String getCacheName() {
        return cacheName;
    }

    public void setCacheName(String cacheName) {
        StormStreamer.cacheName = cacheName;
    }

    public String getIgniteConfigFile() {
        return igniteConfigFile;
    }

    public void setIgniteConfigFile(String igniteConfigFile) {
        StormStreamer.igniteConfigFile = igniteConfigFile;
    }

    public long getAutoFlushFrequency() {
        return this.autoFlushFrequency;
    }

    public void setAutoFlushFrequency(long autoFlushFrequency) {
        this.autoFlushFrequency = autoFlushFrequency;
    }

    public boolean getAllowOverwrite() {
        return this.allowOverwrite;
    }

    public void setAllowOverwrite(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public void start() throws IgniteException {
        A.notNull((Object)igniteConfigFile, (String)"Ignite config file");
        A.notNull((Object)cacheName, (String)"Cache name");
        A.notNull((Object)this.igniteTupleField, (String)"Ignite tuple field");
        this.setIgnite(StreamerContext.getIgnite());
        IgniteDataStreamer dataStreamer = StreamerContext.getStreamer();
        dataStreamer.autoFlushFrequency(this.autoFlushFrequency);
        dataStreamer.allowOverwrite(this.allowOverwrite);
        this.setStreamer(dataStreamer);
        this.log = this.getIgnite().log();
        stopped = false;
    }

    public void stop() throws IgniteException {
        if (stopped) {
            return;
        }
        stopped = true;
        this.getIgnite().dataStreamer(cacheName).close(true);
        this.getIgnite().close();
    }

    public void prepare(Map map, TopologyContext topologyContext, OutputCollector collector) {
        this.start();
        this.collector = collector;
    }

    public void execute(Tuple tuple) {
        if (stopped) {
            return;
        }
        if (!(tuple.getValueByField(this.igniteTupleField) instanceof Map)) {
            throw new IgniteException("Map as a streamer input is expected!");
        }
        Map gridVals = (Map)tuple.getValueByField(this.igniteTupleField);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Tuple (id:" + tuple.getMessageId() + ") from storm: " + gridVals);
            }
            this.getStreamer().addData(gridVals);
            this.collector.ack(tuple);
        }
        catch (Exception e) {
            this.log.error("Error while processing tuple of " + gridVals, (Throwable)e);
            this.collector.fail(tuple);
        }
    }

    public void cleanup() {
        this.stop();
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }

    static /* synthetic */ String access$000() {
        return igniteConfigFile;
    }

    static /* synthetic */ String access$100() {
        return cacheName;
    }

    public static class StreamerContext {
        private StreamerContext() {
        }

        public static Ignite getIgnite() {
            return Holder.IGNITE;
        }

        public static IgniteDataStreamer getStreamer() {
            return Holder.STREAMER;
        }

        private static class Holder {
            private static final Ignite IGNITE = Ignition.start((String)StormStreamer.access$000());
            private static final IgniteDataStreamer STREAMER = IGNITE.dataStreamer(StormStreamer.access$100());

            private Holder() {
            }
        }
    }
}

