/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.shmem;

import java.io.IOException;
import java.io.InputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemorySpace;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IpcSharedMemoryInputStream
extends InputStream {
    private final IpcSharedMemorySpace in;
    private byte[] buf = new byte[1];

    public IpcSharedMemoryInputStream(IpcSharedMemorySpace in) {
        assert (in != null);
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        try {
            int read = this.in.read(this.buf, 0, 1, 0L);
            if (read < 0) {
                return read;
            }
            return this.buf[0] & 0xFF;
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.in.read(b, off, len, 0L);
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.in.unreadCount();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void forceClose() {
        this.in.forceClose();
    }

    public String toString() {
        return S.toString(IpcSharedMemoryInputStream.class, this);
    }
}

