/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;

public class SqlSetStreamingCommand
implements SqlCommand {
    private static final int DFLT_STREAM_BATCH_SIZE = 2048;
    private boolean turnOn;
    private boolean allowOverwrite;
    private int batchSize = 2048;
    private int perNodeParOps;
    private int perNodeBufSize;
    private long flushFreq;
    private boolean ordered;

    @Override
    public SqlCommand parse(SqlLexer lex) {
        this.turnOn = SqlParserUtils.parseBoolean(lex);
        block16: while (lex.lookAhead().tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (lex.lookAhead().token()) {
                case "BATCH_SIZE": {
                    lex.shift();
                    this.checkOffLast(lex);
                    this.batchSize = SqlParserUtils.parseInt(lex);
                    if (this.batchSize > 0) continue block16;
                    throw SqlParserUtils.error(lex, "Invalid batch size (must be positive).");
                }
                case "PER_NODE_BUFFER_SIZE": {
                    lex.shift();
                    this.checkOffLast(lex);
                    this.perNodeBufSize = SqlParserUtils.parseInt(lex);
                    if (this.perNodeBufSize > 0) continue block16;
                    throw SqlParserUtils.error(lex, "Invalid per node buffer size (must be positive).");
                }
                case "PER_NODE_PARALLEL_OPERATIONS": {
                    lex.shift();
                    this.checkOffLast(lex);
                    this.perNodeParOps = SqlParserUtils.parseInt(lex);
                    if (this.perNodeParOps > 0) continue block16;
                    throw SqlParserUtils.error(lex, "Invalid per node parallel operations number (must be positive).");
                }
                case "ALLOW_OVERWRITE": {
                    lex.shift();
                    this.checkOffLast(lex);
                    this.allowOverwrite = SqlParserUtils.parseBoolean(lex);
                    continue block16;
                }
                case "FLUSH_FREQUENCY": {
                    lex.shift();
                    this.checkOffLast(lex);
                    this.flushFreq = SqlParserUtils.parseInt(lex);
                    if (this.flushFreq > 0L) continue block16;
                    throw SqlParserUtils.error(lex, "Invalid flush frequency (must be positive).");
                }
                case "ORDERED": {
                    lex.shift();
                    this.checkOffLast(lex);
                    this.ordered = true;
                    continue block16;
                }
            }
            return this;
        }
        return this;
    }

    private void checkOffLast(SqlLexer lex) throws SqlParseException {
        if (!this.turnOn) {
            assert (lex.tokenType() == SqlLexerTokenType.DEFAULT);
            throw SqlParserUtils.errorUnexpectedToken(lex);
        }
    }

    public boolean isTurnOn() {
        return this.turnOn;
    }

    public boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public int perNodeParallelOperations() {
        return this.perNodeParOps;
    }

    public int perNodeBufferSize() {
        return this.perNodeBufSize;
    }

    public long flushFrequency() {
        return this.flushFreq;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public String schemaName() {
        return null;
    }

    @Override
    public void schemaName(String schemaName) {
    }
}

