/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.query;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.cache.query.PlatformAbstractQueryCursor;

public class PlatformFieldsQueryCursor
extends PlatformAbstractQueryCursor<List<?>> {
    private static final int OP_GET_FIELD_NAMES = 7;

    public PlatformFieldsQueryCursor(PlatformContext platformCtx, QueryCursorEx<List<?>> cursor, int batchSize) {
        super(platformCtx, cursor, batchSize);
    }

    @Override
    protected void write(BinaryRawWriterEx writer, List vals) {
        assert (vals != null);
        int rowSizePos = writer.reserveInt();
        writer.writeInt(vals.size());
        for (Object val : vals) {
            writer.writeObjectDetached(val);
        }
        int rowEndPos = writer.out().position();
        writer.writeInt(rowSizePos, rowEndPos - rowSizePos);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 7) {
            FieldsQueryCursor fq = (FieldsQueryCursor)((Object)this.cursor());
            int cnt = fq.getColumnsCount();
            writer.writeInt(cnt);
            for (int i = 0; i < cnt; ++i) {
                writer.writeString(fq.getFieldName(i));
            }
        } else {
            super.processOutStream(type, writer);
        }
    }
}

