/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class FixRemoveId
extends PageDeltaRecord {
    private long rmvId;

    public FixRemoveId(int grpId, long pageId, long rmvId) {
        super(grpId, pageId);
        this.rmvId = rmvId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        Object io = PageIO.getBPlusIO(pageAddr);
        ((BPlusIO)io).setRemoveId(pageAddr, this.rmvId);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_FIX_REMOVE_ID;
    }

    public long removeId() {
        return this.rmvId;
    }

    @Override
    public String toString() {
        return S.toString(FixRemoveId.class, this, "super", super.toString());
    }
}

