/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.net.URL;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;

public class JdbcUtils {
    public static int type(String cls) {
        if (Boolean.class.getName().equals(cls) || Boolean.TYPE.getName().equals(cls)) {
            return 16;
        }
        if (Byte.class.getName().equals(cls) || Byte.TYPE.getName().equals(cls)) {
            return -6;
        }
        if (Short.class.getName().equals(cls) || Short.TYPE.getName().equals(cls)) {
            return 5;
        }
        if (Integer.class.getName().equals(cls) || Integer.TYPE.getName().equals(cls)) {
            return 4;
        }
        if (Long.class.getName().equals(cls) || Long.TYPE.getName().equals(cls)) {
            return -5;
        }
        if (Float.class.getName().equals(cls) || Float.TYPE.getName().equals(cls)) {
            return 6;
        }
        if (Double.class.getName().equals(cls) || Double.TYPE.getName().equals(cls)) {
            return 8;
        }
        if (String.class.getName().equals(cls)) {
            return 12;
        }
        if (byte[].class.getName().equals(cls)) {
            return -2;
        }
        if (Time.class.getName().equals(cls)) {
            return 92;
        }
        if (Timestamp.class.getName().equals(cls)) {
            return 93;
        }
        if (Date.class.getName().equals(cls) || java.sql.Date.class.getName().equals(cls)) {
            return 91;
        }
        return 1111;
    }

    public static String typeName(String cls) {
        if (Boolean.class.getName().equals(cls) || Boolean.TYPE.getName().equals(cls)) {
            return "BOOLEAN";
        }
        if (Byte.class.getName().equals(cls) || Byte.TYPE.getName().equals(cls)) {
            return "TINYINT";
        }
        if (Short.class.getName().equals(cls) || Short.TYPE.getName().equals(cls)) {
            return "SMALLINT";
        }
        if (Integer.class.getName().equals(cls) || Integer.TYPE.getName().equals(cls)) {
            return "INTEGER";
        }
        if (Long.class.getName().equals(cls) || Long.TYPE.getName().equals(cls)) {
            return "BIGINT";
        }
        if (Float.class.getName().equals(cls) || Float.TYPE.getName().equals(cls)) {
            return "FLOAT";
        }
        if (Double.class.getName().equals(cls) || Double.TYPE.getName().equals(cls)) {
            return "DOUBLE";
        }
        if (String.class.getName().equals(cls)) {
            return "VARCHAR";
        }
        if (byte[].class.getName().equals(cls)) {
            return "BINARY";
        }
        if (Time.class.getName().equals(cls)) {
            return "TIME";
        }
        if (Timestamp.class.getName().equals(cls)) {
            return "TIMESTAMP";
        }
        if (Date.class.getName().equals(cls) || java.sql.Date.class.getName().equals(cls)) {
            return "DATE";
        }
        return "OTHER";
    }

    public static boolean nullable(String name, String cls) {
        return !"_KEY".equalsIgnoreCase(name) && !"_VAL".equalsIgnoreCase(name) && !Boolean.TYPE.getName().equals(cls) && !Byte.TYPE.getName().equals(cls) && !Short.TYPE.getName().equals(cls) && !Integer.TYPE.getName().equals(cls) && !Long.TYPE.getName().equals(cls) && !Float.TYPE.getName().equals(cls) && !Double.TYPE.getName().equals(cls);
    }

    static boolean isSqlType(Class<?> cls) {
        return QueryUtils.isSqlType(cls) || cls == URL.class;
    }

    public static SQLException convertToSqlException(Exception e, String msgForUnknown) {
        return JdbcUtils.convertToSqlException(e, msgForUnknown, null);
    }

    public static SQLException convertToSqlException(Exception e, String msgForUnknown, String sqlStateForUnknown) {
        Object sqlEx = null;
        for (Throwable t = e; sqlEx == null && t != null; t = t.getCause()) {
            if (t instanceof SQLException) {
                return (SQLException)t;
            }
            if (!(t instanceof IgniteSQLException)) continue;
            return ((IgniteSQLException)t).toJdbcException();
        }
        return new SQLException(msgForUnknown, sqlStateForUnknown, e);
    }
}

