/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;

public class JdbcThinParameterMetadata
implements ParameterMetaData {
    private final List<JdbcParameterMeta> meta;

    public JdbcThinParameterMetadata(List<JdbcParameterMeta> meta) {
        assert (meta != null);
        this.meta = meta;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.meta.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.parameter(param).isNullable();
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.parameter(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.parameter(param).precision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.parameter(param).scale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.parameter(param).type();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.parameter(param).typeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.parameter(param).typeClass();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return this.parameter(param).mode();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Parameters metadata is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcThinParameterMetadata.class);
    }

    private JdbcParameterMeta parameter(int param) throws SQLException {
        if (param <= 0 || param > this.meta.size()) {
            throw new SQLException("Invalid parameter number");
        }
        return this.meta.get(param - 1);
    }
}

