/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.impurity.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.ml.tree.impurity.ImpurityMeasure;
import org.apache.ignite.ml.tree.impurity.util.StepFunction;
import org.apache.ignite.ml.tree.impurity.util.StepFunctionCompressor;

public class SimpleStepFunctionCompressor<T extends ImpurityMeasure<T>>
implements StepFunctionCompressor<T> {
    private static final long serialVersionUID = -3231787633598409157L;
    private final int minSizeToBeCompressed;
    private final double minImpurityIncreaseForRecord;
    private final double minImpurityDecreaseForRecord;

    public SimpleStepFunctionCompressor() {
        this(10, 0.1, 0.05);
    }

    public SimpleStepFunctionCompressor(int minSizeToBeCompressed, double minImpurityIncreaseForRecord, double minImpurityDecreaseForRecord) {
        this.minSizeToBeCompressed = minSizeToBeCompressed;
        this.minImpurityIncreaseForRecord = minImpurityIncreaseForRecord;
        this.minImpurityDecreaseForRecord = minImpurityDecreaseForRecord;
    }

    @Override
    public StepFunction<T> compress(StepFunction<T> function) {
        double[] arguments = function.getX();
        ImpurityMeasure[] values = function.getY();
        if (arguments.length >= this.minSizeToBeCompressed) {
            List<StepFunctionPoint> points = new ArrayList<StepFunctionPoint>();
            for (int i = 0; i < arguments.length; ++i) {
                points.add(new StepFunctionPoint(this, arguments[i], values[i]));
            }
            points = this.compress(points);
            double[] resX = new double[points.size()];
            ImpurityMeasure[] resY = Arrays.copyOf(values, points.size());
            for (int i = 0; i < points.size(); ++i) {
                StepFunctionPoint pnt = points.get(i);
                resX[i] = pnt.x;
                resY[i] = pnt.y;
            }
            return new StepFunction(resX, resY);
        }
        return function;
    }

    @Override
    private List<StepFunctionPoint> compress(List<StepFunctionPoint> points) {
        ArrayList<StepFunctionPoint> res = new ArrayList<StepFunctionPoint>();
        double minImpurity = Double.MAX_VALUE;
        double maxImpurity = Double.MIN_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            StepFunctionPoint pnt = points.get(i);
            double impurity = pnt.y.impurity();
            if (impurity > maxImpurity) {
                maxImpurity = impurity;
            }
            if (!(impurity < minImpurity)) continue;
            minImpurity = impurity;
        }
        Double prev = null;
        for (StepFunctionPoint pnt : points) {
            double impurity = (pnt.y.impurity() - minImpurity) / (maxImpurity - minImpurity);
            if (prev != null && !(prev - impurity >= this.minImpurityDecreaseForRecord) && !(impurity - prev >= this.minImpurityIncreaseForRecord)) continue;
            prev = impurity;
            res.add(pnt);
        }
        return res;
    }

    private class StepFunctionPoint {
        private final double x;
        private final T y;
        final /* synthetic */ SimpleStepFunctionCompressor this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        StepFunctionPoint(double y, T t) {
            void x;
            this.this$0 = (SimpleStepFunctionCompressor)d;
            this.x = x;
            this.y = y;
        }
    }
}

