/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.impurity.mse;

import org.apache.ignite.ml.tree.data.DecisionTreeData;
import org.apache.ignite.ml.tree.impurity.ImpurityMeasure;
import org.apache.ignite.ml.tree.impurity.ImpurityMeasureCalculator;
import org.apache.ignite.ml.tree.impurity.mse.MSEImpurityMeasure;
import org.apache.ignite.ml.tree.impurity.util.StepFunction;

public class MSEImpurityMeasureCalculator
implements ImpurityMeasureCalculator<MSEImpurityMeasure> {
    private static final long serialVersionUID = 288747414953756824L;

    @Override
    public StepFunction<MSEImpurityMeasure>[] calculate(DecisionTreeData data) {
        double[][] features = data.getFeatures();
        double[] labels = data.getLabels();
        if (features.length > 0) {
            StepFunction[] res = new StepFunction[features[0].length];
            for (int col = 0; col < res.length; ++col) {
                data.sort(col);
                double[] x = new double[features.length + 1];
                ImpurityMeasure[] y = new MSEImpurityMeasure[features.length + 1];
                x[0] = Double.NEGATIVE_INFINITY;
                for (int leftSize = 0; leftSize <= features.length; ++leftSize) {
                    int i;
                    double leftY = 0.0;
                    double leftY2 = 0.0;
                    double rightY = 0.0;
                    double rightY2 = 0.0;
                    for (i = 0; i < leftSize; ++i) {
                        leftY += labels[i];
                        leftY2 += Math.pow(labels[i], 2.0);
                    }
                    for (i = leftSize; i < features.length; ++i) {
                        rightY += labels[i];
                        rightY2 += Math.pow(labels[i], 2.0);
                    }
                    if (leftSize < features.length) {
                        x[leftSize + 1] = features[leftSize][col];
                    }
                    y[leftSize] = new MSEImpurityMeasure(leftY, leftY2, leftSize, rightY, rightY2, features.length - leftSize);
                }
                res[col] = new StepFunction(x, y);
            }
            return res;
        }
        return null;
    }
}

