/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.data;

import org.apache.ignite.ml.tree.TreeFilter;

public class DecisionTreeData
implements AutoCloseable {
    private final double[][] features;
    private final double[] labels;

    public DecisionTreeData(double[][] features, double[] labels) {
        assert (features.length == labels.length) : "Features and labels have to be the same length";
        this.features = features;
        this.labels = labels;
    }

    public DecisionTreeData filter(TreeFilter filter) {
        int size = 0;
        for (int i = 0; i < this.features.length; ++i) {
            if (!filter.test(this.features[i])) continue;
            ++size;
        }
        double[][] newFeatures = new double[size][];
        double[] newLabels = new double[size];
        int ptr = 0;
        for (int i = 0; i < this.features.length; ++i) {
            if (!filter.test(this.features[i])) continue;
            newFeatures[ptr] = this.features[i];
            newLabels[ptr] = this.labels[i];
            ++ptr;
        }
        return new DecisionTreeData(newFeatures, newLabels);
    }

    public void sort(int col) {
        this.sort(col, 0, this.features.length - 1);
    }

    private void sort(int col, int from, int to) {
        if (from < to) {
            double pivot = this.features[(from + to) / 2][col];
            int i = from;
            int j = to;
            while (i <= j) {
                while (this.features[i][col] < pivot) {
                    ++i;
                }
                while (this.features[j][col] > pivot) {
                    --j;
                }
                if (i > j) continue;
                double[] tmpFeature = this.features[i];
                this.features[i] = this.features[j];
                this.features[j] = tmpFeature;
                double tmpLb = this.labels[i];
                this.labels[i] = this.labels[j];
                this.labels[j] = tmpLb;
                ++i;
                --j;
            }
            this.sort(col, from, j);
            this.sort(col, i, to);
        }
    }

    public double[][] getFeatures() {
        return this.features;
    }

    public double[] getLabels() {
        return this.labels;
    }

    @Override
    public void close() {
    }
}

