/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree;

import org.apache.ignite.ml.tree.DecisionTreeNode;

public class DecisionTreeConditionalNode
implements DecisionTreeNode {
    private static final long serialVersionUID = 981630737007982172L;
    private final int col;
    private final double threshold;
    private final DecisionTreeNode thenNode;
    private final DecisionTreeNode elseNode;

    DecisionTreeConditionalNode(int col, double threshold, DecisionTreeNode thenNode, DecisionTreeNode elseNode) {
        this.col = col;
        this.threshold = threshold;
        this.thenNode = thenNode;
        this.elseNode = elseNode;
    }

    @Override
    public Double apply(double[] features) {
        return features[this.col] > this.threshold ? (Double)this.thenNode.apply(features) : (Double)this.elseNode.apply(features);
    }

    public int getCol() {
        return this.col;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public DecisionTreeNode getThenNode() {
        return this.thenNode;
    }

    public DecisionTreeNode getElseNode() {
        return this.elseNode;
    }
}

