/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.structures;

import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.exceptions.NoDataException;
import org.apache.ignite.ml.math.exceptions.knn.NoLabelVectorException;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOnHeapVector;
import org.apache.ignite.ml.math.impls.vector.SparseDistributedVector;
import org.apache.ignite.ml.structures.Dataset;
import org.apache.ignite.ml.structures.LabeledVector;

public class LabeledDataset<L, Row extends LabeledVector>
extends Dataset<Row>
implements AutoCloseable {
    public LabeledDataset() {
    }

    public LabeledDataset(int rowSize, int colSize, boolean isDistributed) {
        this(rowSize, colSize, null, isDistributed);
    }

    public LabeledDataset(int rowSize, int colSize) {
        this(rowSize, colSize, null, false);
    }

    public LabeledDataset(int rowSize, int colSize, String[] featureNames, boolean isDistributed) {
        super(rowSize, colSize, featureNames, isDistributed);
        this.initializeDataWithLabeledVectors();
    }

    public LabeledDataset(Row[] data) {
        super(data);
    }

    private void initializeDataWithLabeledVectors() {
        this.data = new LabeledVector[this.rowSize];
        for (int i = 0; i < this.rowSize; ++i) {
            ((LabeledVector[])this.data)[i] = new LabeledVector<Vector, Object>(LabeledDataset.emptyVector(this.colSize, this.isDistributed), null);
        }
    }

    public LabeledDataset(Row[] data, int colSize) {
        super(data, colSize);
    }

    public LabeledDataset(double[][] mtx, double[] lbs) {
        this(mtx, lbs, null, false);
    }

    public LabeledDataset(double[][] mtx, double[] lbs, String[] featureNames, boolean isDistributed) {
        assert (mtx != null);
        assert (lbs != null);
        if (mtx.length != lbs.length) {
            throw new CardinalityException(lbs.length, mtx.length);
        }
        if (mtx[0] == null) {
            throw new NoDataException("Pass filled array, the first vector is empty");
        }
        this.rowSize = lbs.length;
        this.colSize = mtx[0].length;
        if (featureNames == null) {
            this.generateFeatureNames();
        } else {
            assert (this.colSize == featureNames.length);
            this.convertStringNamesToFeatureMetadata(featureNames);
        }
        this.data = new LabeledVector[this.rowSize];
        for (int i = 0; i < this.rowSize; ++i) {
            ((LabeledVector[])this.data)[i] = new LabeledVector<Vector, Double>(LabeledDataset.emptyVector(this.colSize, isDistributed), lbs[i]);
            for (int j = 0; j < this.colSize; ++j) {
                try {
                    ((LabeledVector[])this.data)[i].features().set(j, mtx[i][j]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoDataException("No data in given matrix by coordinates (" + i + "," + j + ")");
                }
            }
        }
    }

    public double label(int idx) {
        LabeledVector labeledVector = ((LabeledVector[])this.data)[idx];
        if (labeledVector != null) {
            return (Double)labeledVector.label();
        }
        return Double.NaN;
    }

    public double[] labels() {
        assert (this.data != null);
        assert (((LabeledVector[])this.data).length > 0);
        double[] labels = new double[((LabeledVector[])this.data).length];
        for (int i = 0; i < ((LabeledVector[])this.data).length; ++i) {
            labels[i] = (Double)((LabeledVector[])this.data)[i].label();
        }
        return labels;
    }

    public void setLabel(int idx, double lb) {
        LabeledVector labeledVector = ((LabeledVector[])this.data)[idx];
        if (labeledVector == null) {
            throw new NoLabelVectorException(idx);
        }
        labeledVector.setLabel(lb);
    }

    public static Vector emptyVector(int size, boolean isDistributed) {
        if (isDistributed) {
            return new SparseDistributedVector(size);
        }
        return new DenseLocalOnHeapVector(size);
    }

    public LabeledDataset copy() {
        LabeledDataset res = new LabeledDataset((LabeledVector[])this.data, this.colSize);
        res.isDistributed = this.isDistributed;
        res.meta = this.meta;
        for (int i = 0; i < this.rowSize; ++i) {
            res.setLabel(i, this.label(i));
        }
        return res;
    }

    @Override
    public void close() throws Exception {
    }
}

