/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.normalization;

import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.preprocessing.PreprocessingTrainer;
import org.apache.ignite.ml.preprocessing.normalization.NormalizationPartitionData;
import org.apache.ignite.ml.preprocessing.normalization.NormalizationPreprocessor;

public class NormalizationTrainer<K, V>
implements PreprocessingTrainer<K, V, double[], double[]> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NormalizationPreprocessor<K, V> fit(DatasetBuilder<K, V> datasetBuilder, IgniteBiFunction<K, V, double[]> basePreprocessor) {
        try (Dataset<EmptyContext, NormalizationPartitionData> dataset = datasetBuilder.build((upstream, upstreamSize) -> new EmptyContext(), (upstream, upstreamSize, ctx) -> {
            double[] min = null;
            double[] max = null;
            while (upstream.hasNext()) {
                int i;
                UpstreamEntry entity = (UpstreamEntry)upstream.next();
                double[] row = (double[])basePreprocessor.apply(entity.getKey(), entity.getValue());
                if (min == null) {
                    min = new double[row.length];
                    for (i = 0; i < min.length; ++i) {
                        min[i] = Double.MAX_VALUE;
                    }
                } else assert (min.length == row.length) : "Base preprocessor must return exactly " + min.length + " features";
                if (max == null) {
                    max = new double[row.length];
                    for (i = 0; i < max.length; ++i) {
                        max[i] = -1.7976931348623157E308;
                    }
                } else assert (max.length == row.length) : "Base preprocessor must return exactly " + min.length + " features";
                for (i = 0; i < row.length; ++i) {
                    if (row[i] < min[i]) {
                        min[i] = row[i];
                    }
                    if (!(row[i] > max[i])) continue;
                    max[i] = row[i];
                }
            }
            return new NormalizationPartitionData(min, max);
        });){
            double[][] minMax = (double[][])dataset.compute(data -> {
                Object object;
                if (data.getMin() != null) {
                    double[][] dArrayArray = new double[2][];
                    dArrayArray[0] = data.getMin();
                    object = dArrayArray;
                    dArrayArray[1] = data.getMax();
                } else {
                    object = null;
                }
                return object;
            }, (a, b) -> {
                int i;
                if (a == null) {
                    return b;
                }
                if (b == null) {
                    return a;
                }
                double[][] res = new double[2][];
                res[0] = new double[a[0].length];
                for (i = 0; i < res[0].length; ++i) {
                    res[0][i] = Math.min(a[0][i], b[0][i]);
                }
                res[1] = new double[a[1].length];
                for (i = 0; i < res[1].length; ++i) {
                    res[1][i] = Math.max(a[1][i], b[1][i]);
                }
                return res;
            });
            NormalizationPreprocessor<K, V> normalizationPreprocessor = new NormalizationPreprocessor<K, V>(minMax[0], minMax[1], basePreprocessor);
            return normalizationPreprocessor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

