/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.normalization;

import org.apache.ignite.ml.math.functions.IgniteBiFunction;

public class NormalizationPreprocessor<K, V>
implements IgniteBiFunction<K, V, double[]> {
    private static final long serialVersionUID = 6997800576392623469L;
    private final double[] min;
    private final double[] max;
    private final IgniteBiFunction<K, V, double[]> basePreprocessor;

    public NormalizationPreprocessor(double[] min, double[] max, IgniteBiFunction<K, V, double[]> basePreprocessor) {
        this.min = min;
        this.max = max;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public double[] apply(K k, V v) {
        double[] res = (double[])this.basePreprocessor.apply(k, v);
        assert (res.length == this.min.length);
        assert (res.length == this.max.length);
        for (int i = 0; i < res.length; ++i) {
            res[i] = (res[i] - this.min[i]) / (this.max[i] - this.min[i]);
        }
        return res;
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getMax() {
        return this.max;
    }
}

