/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.optimization.updatecalculators;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOnHeapVector;

public class NesterovParameterUpdate
implements Serializable {
    private static final long serialVersionUID = -6370106062737202385L;
    protected Vector prevIterationUpdates;

    public NesterovParameterUpdate(int paramsCnt) {
        this.prevIterationUpdates = new DenseLocalOnHeapVector(paramsCnt).assign(0.0);
    }

    public NesterovParameterUpdate(Vector prevIterationUpdates) {
        this.prevIterationUpdates = prevIterationUpdates;
    }

    public NesterovParameterUpdate setPreviousUpdates(Vector updates) {
        this.prevIterationUpdates = updates;
        return this;
    }

    public Vector prevIterationUpdates() {
        return this.prevIterationUpdates;
    }

    public static NesterovParameterUpdate sum(List<NesterovParameterUpdate> parameters) {
        return parameters.stream().filter(Objects::nonNull).map(NesterovParameterUpdate::prevIterationUpdates).reduce(Vector::plus).map(NesterovParameterUpdate::new).orElse(null);
    }

    public static NesterovParameterUpdate avg(List<NesterovParameterUpdate> parameters) {
        NesterovParameterUpdate sum = NesterovParameterUpdate.sum(parameters);
        return sum != null ? sum.setPreviousUpdates(sum.prevIterationUpdates().divide(parameters.stream().filter(Objects::nonNull).count())) : null;
    }
}

