/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.util;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import org.apache.ignite.internal.util.GridArgumentCheck;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;
import org.apache.ignite.ml.math.impls.matrix.CacheMatrix;
import org.apache.ignite.ml.math.impls.matrix.DenseLocalOnHeapMatrix;
import org.apache.ignite.ml.math.impls.matrix.MatrixView;
import org.apache.ignite.ml.math.impls.matrix.PivotedMatrixView;
import org.apache.ignite.ml.math.impls.matrix.RandomMatrix;
import org.apache.ignite.ml.math.impls.matrix.SparseBlockDistributedMatrix;
import org.apache.ignite.ml.math.impls.matrix.SparseDistributedMatrix;
import org.apache.ignite.ml.math.impls.matrix.SparseLocalOnHeapMatrix;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOnHeapVector;

public class MatrixUtil {
    public static Matrix like(Matrix matrix) {
        if (MatrixUtil.isCopyLikeSupport(matrix)) {
            return new DenseLocalOnHeapMatrix(matrix.rowSize(), matrix.columnSize());
        }
        return matrix.like(matrix.rowSize(), matrix.columnSize());
    }

    public static Matrix identityLike(Matrix matrix, int n) {
        Matrix res = MatrixUtil.like(matrix, n, n);
        for (int i = 0; i < n; ++i) {
            res.setX(i, i, 1.0);
        }
        return res;
    }

    public static Matrix like(Matrix matrix, int rows, int cols) {
        if (MatrixUtil.isCopyLikeSupport(matrix)) {
            return new DenseLocalOnHeapMatrix(rows, cols);
        }
        return matrix.like(rows, cols);
    }

    public static Vector likeVector(Matrix matrix, int crd) {
        if (MatrixUtil.isCopyLikeSupport(matrix)) {
            return new DenseLocalOnHeapVector(crd);
        }
        return matrix.likeVector(crd);
    }

    private static boolean isDistributed(Matrix matrix) {
        return matrix instanceof SparseDistributedMatrix || matrix instanceof SparseBlockDistributedMatrix;
    }

    public static Vector likeVector(Matrix matrix) {
        return MatrixUtil.likeVector(matrix, matrix.rowSize());
    }

    public static Matrix copy(Matrix matrix) {
        if (MatrixUtil.isCopyLikeSupport(matrix)) {
            DenseLocalOnHeapMatrix cp = new DenseLocalOnHeapMatrix(matrix.rowSize(), matrix.columnSize());
            cp.assign(matrix);
            return cp;
        }
        return matrix.copy();
    }

    public static DenseLocalOnHeapMatrix asDense(SparseLocalOnHeapMatrix m, int acsMode) {
        DenseLocalOnHeapMatrix res = new DenseLocalOnHeapMatrix(m.rowSize(), m.columnSize(), acsMode);
        IntIterator intIterator = m.indexesMap().keySet().iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            IntIterator intIterator2 = ((IntSet)m.indexesMap().get(row)).iterator();
            while (intIterator2.hasNext()) {
                int col = (Integer)intIterator2.next();
                res.set(row, col, m.get(row, col));
            }
        }
        return res;
    }

    private static boolean isCopyLikeSupport(Matrix matrix) {
        return matrix instanceof RandomMatrix || matrix instanceof MatrixView || matrix instanceof CacheMatrix || matrix instanceof PivotedMatrixView;
    }

    public static DenseLocalOnHeapMatrix fromList(List<Vector> vecs, boolean entriesAreRows) {
        GridArgumentCheck.notEmpty(vecs, (String)"vecs");
        int dim = vecs.get(0).size();
        int vecsSize = vecs.size();
        DenseLocalOnHeapMatrix res = new DenseLocalOnHeapMatrix(entriesAreRows ? vecsSize : dim, entriesAreRows ? dim : vecsSize);
        for (int i = 0; i < vecsSize; ++i) {
            for (int j = 0; j < dim; ++j) {
                int r = entriesAreRows ? i : j;
                int c = entriesAreRows ? j : i;
                res.setX(r, c, vecs.get(i).get(j));
            }
        }
        return res;
    }

    public static DenseLocalOnHeapVector localCopyOf(Vector vec) {
        DenseLocalOnHeapVector res = new DenseLocalOnHeapVector(vec.size());
        for (int i = 0; i < vec.size(); ++i) {
            res.setX(i, vec.getX(i));
        }
        return res;
    }

    public static double[][] unflatten(double[] fArr, int colsCnt, int stoMode) {
        int rowsCnt = fArr.length / colsCnt;
        boolean isRowMode = stoMode == 2001;
        double[][] res = new double[rowsCnt][colsCnt];
        for (int i = 0; i < rowsCnt; ++i) {
            for (int j = 0; j < colsCnt; ++j) {
                res[i][j] = fArr[!isRowMode ? i * colsCnt + j : j * rowsCnt + i];
            }
        }
        return res;
    }

    public static void unflatten(double[] fArr, Matrix mtx) {
        assert (mtx != null);
        if (fArr.length <= 0) {
            return;
        }
        int rowsCnt = mtx.rowSize();
        int colsCnt = mtx.columnSize();
        boolean isRowMode = mtx.getStorage().storageMode() == 2001;
        for (int i = 0; i < rowsCnt; ++i) {
            for (int j = 0; j < colsCnt; ++j) {
                mtx.setX(i, j, fArr[!isRowMode ? i * colsCnt + j : j * rowsCnt + i]);
            }
        }
    }

    public static Vector zipWith(Vector v1, Vector v2, IgniteTriFunction<Double, Double, Integer, Double> f) {
        int size = Math.min(v1.size(), v2.size());
        Vector res = v1.like(size);
        for (int row = 0; row < size; ++row) {
            res.setX(row, f.apply(v1.getX(row), v2.getX(row), row));
        }
        return res;
    }

    public static Vector zipFoldByColumns(Matrix mtx1, Matrix mtx2, IgniteBiFunction<Vector, Vector, Double> fun) {
        int cols = Math.min(mtx1.columnSize(), mtx2.columnSize());
        Vector vec = mtx1.likeVector(cols);
        for (int i = 0; i < cols; ++i) {
            vec.setX(i, (Double)fun.apply(mtx1.getCol(i), mtx2.getCol(i)));
        }
        return vec;
    }

    public static Vector zipFoldByRows(Matrix mtx1, Matrix mtx2, IgniteBiFunction<Vector, Vector, Double> fun) {
        int rows = Math.min(mtx1.rowSize(), mtx2.rowSize());
        Vector vec = mtx1.likeVector(rows);
        for (int i = 0; i < rows; ++i) {
            vec.setX(i, (Double)fun.apply(mtx1.viewRow(i), mtx2.viewRow(i)));
        }
        return vec;
    }

    public static double[] flatten(double[][] arr, int stoMode) {
        assert (arr != null);
        assert (arr[0] != null);
        boolean isRowMode = stoMode == 2001;
        int size = arr.length * arr[0].length;
        int rows = isRowMode ? arr.length : arr[0].length;
        int cols = size / rows;
        double[] res = new double[size];
        int iLim = isRowMode ? rows : cols;
        int jLim = isRowMode ? cols : rows;
        for (int i = 0; i < iLim; ++i) {
            for (int j = 0; j < jLim; ++j) {
                res[isRowMode ? j * iLim + i : i * jLim + j] = arr[i][j];
            }
        }
        return res;
    }

    public static Matrix elementWiseMinus(Matrix mtx1, Matrix mtx2) {
        mtx1.map(mtx2, (a, b) -> a - b);
        return mtx1;
    }

    public static Matrix elementWiseTimes(Matrix mtx1, Matrix mtx2) {
        mtx1.map(mtx2, (a, b) -> a * b);
        return mtx1;
    }
}

