/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import java.util.Map;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.impls.storage.vector.SingleElementVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class SingleElementVector
extends AbstractVector {
    public SingleElementVector() {
    }

    public SingleElementVector(int size, int idx, double val) {
        super(new SingleElementVectorStorage(size, idx, val));
    }

    public SingleElementVector(Map<String, Object> args) {
        assert (args != null);
        if (!(args.containsKey("size") && args.containsKey("index") && args.containsKey("value"))) {
            throw new UnsupportedOperationException("Invalid constructor argument(s).");
        }
        int size = (Integer)args.get("size");
        int idx = (Integer)args.get("index");
        double val = (Double)args.get("value");
        this.setStorage(new SingleElementVectorStorage(size, idx, val));
    }

    private SingleElementVectorStorage storage() {
        return (SingleElementVectorStorage)this.getStorage();
    }

    @Override
    public Vector.Element minElement() {
        return this.makeElement(this.storage().index());
    }

    @Override
    public Vector.Element maxElement() {
        return this.makeElement(this.storage().index());
    }

    @Override
    public double sum() {
        return this.getX(this.storage().index());
    }

    @Override
    public int nonZeroElements() {
        return this.isZero(this.get(this.storage().index())) ? 0 : 1;
    }

    @Override
    public Vector like(int crd) {
        int idx = this.storage().index();
        return new SingleElementVector(crd, idx, this.getX(idx));
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        throw new UnsupportedOperationException();
    }
}

