/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.impls.storage.vector.PivotedVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class PivotedVectorView
extends AbstractVector {
    private Vector vec;

    public PivotedVectorView(Vector vec, int[] pivot, int[] unpivot) {
        this.setStorage(new PivotedVectorStorage(vec.getStorage(), pivot, unpivot));
        this.checkCardinality(pivot);
        this.checkCardinality(unpivot);
        this.vec = vec;
    }

    public PivotedVectorView(Vector vec, int[] pivot) {
        this.setStorage(new PivotedVectorStorage(vec.getStorage(), pivot));
        this.checkCardinality(pivot);
        this.vec = vec;
    }

    private PivotedVectorStorage storage() {
        return (PivotedVectorStorage)this.getStorage();
    }

    public PivotedVectorView() {
    }

    public Vector getBaseVector() {
        return this.vec;
    }

    public int pivot(int i) {
        return this.storage().pivot()[i];
    }

    public int unpivot(int i) {
        return this.storage().unpivot()[i];
    }

    @Override
    protected Vector.Element makeElement(final int idx) {
        this.checkIndex(idx);
        final int exIdx = this.storage().pivot()[idx];
        return new Vector.Element(){

            @Override
            public double get() {
                return PivotedVectorView.this.storageGet(idx);
            }

            @Override
            public int index() {
                return exIdx;
            }

            @Override
            public void set(double val) {
                PivotedVectorView.this.storageSet(idx, val);
            }
        };
    }

    @Override
    public Vector copy() {
        PivotedVectorStorage sto = this.storage();
        return new PivotedVectorView(this.vec, sto.pivot(), sto.unpivot());
    }

    @Override
    public Vector like(int crd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return this.vec.likeMatrix(rows, cols);
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.copy().map(Functions.mult(x));
        }
        return super.times(x);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.vec);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.vec = (Vector)in.readObject();
    }
}

