/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.distributed.ValueMapper;
import org.apache.ignite.ml.math.distributed.VectorKeyMapper;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.impls.storage.vector.CacheVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class CacheVector<K, V>
extends AbstractVector {
    public CacheVector() {
    }

    public CacheVector(int size, IgniteCache<K, V> cache, VectorKeyMapper<K> keyFunc, ValueMapper<V> valMapper) {
        this.setStorage(new CacheVectorStorage<K, V>(size, cache, keyFunc, valMapper));
    }

    private Vector mapOverCache(IgniteFunction<Double, Double> mapper) {
        CacheVectorStorage<K, V> sto = this.storage();
        CacheUtils.map(sto.cache().getName(), sto.keyMapper(), sto.valueMapper(), mapper);
        return this;
    }

    @Override
    public double minValue() {
        CacheVectorStorage<K, V> sto = this.storage();
        return CacheUtils.min(sto.cache().getName(), sto.keyMapper(), sto.valueMapper());
    }

    @Override
    public double maxValue() {
        CacheVectorStorage<K, V> sto = this.storage();
        return CacheUtils.max(sto.cache().getName(), sto.keyMapper(), sto.valueMapper());
    }

    @Override
    public Vector map(IgniteDoubleFunction<Double> fun) {
        return this.mapOverCache(fun::apply);
    }

    @Override
    public Vector map(IgniteBiFunction<Double, Double, Double> fun, double y) {
        return super.map(fun, y);
    }

    @Override
    public double sum() {
        CacheVectorStorage<K, V> sto = this.storage();
        return CacheUtils.sum(sto.cache().getName(), sto.keyMapper(), sto.valueMapper());
    }

    @Override
    public Vector assign(double val) {
        return this.mapOverCache(d -> val);
    }

    @Override
    public Vector plus(double x) {
        return this.mapOverCache(d -> d + x);
    }

    @Override
    public Vector divide(double x) {
        return this.mapOverCache(d -> d / x);
    }

    @Override
    public Vector times(double x) {
        return this.mapOverCache(d -> d * x);
    }

    private CacheVectorStorage<K, V> storage() {
        return (CacheVectorStorage)this.getStorage();
    }

    @Override
    public Vector like(int crd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        throw new UnsupportedOperationException();
    }
}

