/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteIntDoubleToDoubleBiFunction;
import org.apache.ignite.ml.math.impls.matrix.FunctionMatrix;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;
import org.apache.ignite.ml.math.impls.vector.ConstantVector;
import org.apache.ignite.ml.math.impls.vector.FunctionVector;

public abstract class AbstractReadOnlyVector
extends AbstractVector {
    public AbstractReadOnlyVector() {
    }

    public AbstractReadOnlyVector(VectorStorage sto) {
        super(true, sto);
    }

    @Override
    public Matrix cross(Vector vec) {
        return new FunctionMatrix(this.size(), vec.size(), (row, col) -> vec.get((int)col) * this.get((int)row));
    }

    @Override
    public Matrix toMatrix(boolean rowLike) {
        return new FunctionMatrix(rowLike ? 1 : this.size(), rowLike ? this.size() : 1, (row, col) -> rowLike ? this.get((int)col) : this.get((int)row));
    }

    @Override
    public Matrix toMatrixPlusOne(boolean rowLike, double zeroVal) {
        return new FunctionMatrix(rowLike ? 1 : this.size() + 1, rowLike ? this.size() + 1 : 1, (row, col) -> {
            if (row == 0 && col == 0) {
                return zeroVal;
            }
            return rowLike ? this.get(col - 1) : this.get(row - 1);
        });
    }

    @Override
    public Vector copy() {
        return this;
    }

    @Override
    public Vector logNormalize() {
        return this.logNormalize(2.0, Math.sqrt(this.getLengthSquared()));
    }

    @Override
    public Vector logNormalize(double power) {
        return this.logNormalize(power, this.kNorm(power));
    }

    @Override
    public Vector map(IgniteDoubleFunction<Double> fun) {
        return new FunctionVector(this.size(), i -> (Double)fun.apply(this.get((int)i)));
    }

    @Override
    public Vector map(Vector vec, IgniteBiFunction<Double, Double, Double> fun) {
        this.checkCardinality(vec);
        return new FunctionVector(this.size(), i -> (Double)fun.apply(this.get((int)i), vec.get((int)i)));
    }

    @Override
    public Vector map(IgniteBiFunction<Double, Double, Double> fun, double y) {
        return new FunctionVector(this.size(), i -> (Double)fun.apply(this.get((int)i), y));
    }

    @Override
    public Vector divide(double x) {
        if (x == 1.0) {
            return this;
        }
        return new FunctionVector(this.size(), i -> this.get((int)i) / x);
    }

    @Override
    public Vector times(double x) {
        return x == 0.0 ? new ConstantVector(this.size(), 0.0) : new FunctionVector(this.size(), i -> this.get((int)i) * x);
    }

    private Vector logNormalize(double power, double normLen) {
        assert (!Double.isInfinite(power) && !(power <= 1.0));
        double denominator = normLen * Math.log(power);
        return new FunctionVector(this.size(), idx -> Math.log1p(this.get((int)idx)) / denominator);
    }

    @Override
    public void compute(int idx, IgniteIntDoubleToDoubleBiFunction f) {
        throw new UnsupportedOperationException();
    }
}

