/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.stream.IntStream;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.ml.math.VectorStorage;

public class DenseLocalOffHeapVectorStorage
implements VectorStorage {
    private int size;
    private transient long ptr;
    private int ptrInitHash;

    public DenseLocalOffHeapVectorStorage() {
    }

    public DenseLocalOffHeapVectorStorage(int size) {
        assert (size > 0);
        this.size = size;
        this.allocateMemory(size);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        return GridUnsafe.getDouble((long)this.pointerOffset(i));
    }

    @Override
    public void set(int i, double v) {
        GridUnsafe.putDouble((long)this.pointerOffset(i), (double)v);
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public double[] data() {
        return null;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.ptrInitHash);
        for (int i = 0; i < this.size; ++i) {
            out.writeDouble(this.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.allocateMemory(this.size);
        this.ptrInitHash = in.readInt();
        for (int i = 0; i < this.size; ++i) {
            this.set(i, in.readDouble());
        }
    }

    @Override
    public void destroy() {
        GridUnsafe.freeMemory((long)this.ptr);
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.size;
        res = res * 37 + this.ptrInitHash;
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenseLocalOffHeapVectorStorage that = (DenseLocalOffHeapVectorStorage)o;
        return this.size == that.size && this.isMemoryEquals(that);
    }

    private boolean isMemoryEquals(DenseLocalOffHeapVectorStorage otherStorage) {
        return IntStream.range(0, this.size).parallel().noneMatch(idx -> Double.compare(this.get(idx), otherStorage.get(idx)) != 0);
    }

    private long pointerOffset(int i) {
        return this.ptr + (long)(i * 8);
    }

    private void allocateMemory(int size) {
        this.ptr = GridUnsafe.allocateMemory((long)(size * 8));
        this.ptrInitHash = Long.hashCode(this.ptr);
    }
}

