/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;

public class ConstantVectorStorage
implements VectorStorage {
    private int size;
    private double val;

    public ConstantVectorStorage() {
    }

    public ConstantVectorStorage(int size, double val) {
        assert (size > 0);
        this.size = size;
        this.val = val;
    }

    public double constant() {
        return this.val;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        return this.val;
    }

    @Override
    public void set(int i, double v) {
        throw new UnsupportedOperationException("Can't set value into constant vector.");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeDouble(this.val);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.val = in.readDouble();
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.size;
        res = res * 37 + Double.hashCode(this.val);
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantVectorStorage that = (ConstantVectorStorage)o;
        return this.size == that.size && this.val == that.val;
    }
}

