/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.distributed.ValueMapper;
import org.apache.ignite.ml.math.distributed.VectorKeyMapper;

public class CacheVectorStorage<K, V>
implements VectorStorage {
    private int size;
    private VectorKeyMapper<K> keyMapper;
    private ValueMapper<V> valMapper;
    private IgniteCache<K, V> cache;

    public CacheVectorStorage() {
    }

    public CacheVectorStorage(int size, IgniteCache<K, V> cache, VectorKeyMapper<K> keyMapper, ValueMapper<V> valMapper) {
        assert (size > 0);
        assert (cache != null);
        assert (keyMapper != null);
        assert (valMapper != null);
        this.size = size;
        this.cache = cache;
        this.keyMapper = keyMapper;
        this.valMapper = valMapper;
    }

    public IgniteCache<K, V> cache() {
        return this.cache;
    }

    public VectorKeyMapper<K> keyMapper() {
        return this.keyMapper;
    }

    public ValueMapper<V> valueMapper() {
        return this.valMapper;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        return this.valMapper.toDouble(this.cache.get(this.keyMapper.apply(i)));
    }

    @Override
    public void set(int i, double v) {
        this.cache.put(this.keyMapper.apply(i), this.valMapper.fromDouble(v));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeObject(this.keyMapper);
        out.writeObject(this.valMapper);
        out.writeUTF(this.cache.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.keyMapper = (VectorKeyMapper)in.readObject();
        this.valMapper = (ValueMapper)in.readObject();
        this.cache = Ignition.localIgnite().getOrCreateCache(in.readUTF());
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return true;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.size();
        res = res * 37 + this.keyMapper.hashCode();
        res = res * 37 + this.valMapper.hashCode();
        res = res * 37 + this.cache.hashCode();
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CacheVectorStorage that = (CacheVectorStorage)obj;
        return this.size == that.size && (this.keyMapper != null ? this.keyMapper.getClass().equals(that.keyMapper.getClass()) : that.keyMapper == null) && (this.valMapper != null ? this.valMapper.getClass().equals(that.valMapper.getClass()) : that.valMapper == null) && (this.cache != null ? this.cache.equals(that.cache) : that.cache == null);
    }
}

