/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.IntIntDoubleToVoidFunction;
import org.apache.ignite.ml.math.functions.IntIntToDoubleFunction;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.FunctionMatrixStorage;

public class FunctionMatrix
extends AbstractMatrix {
    public FunctionMatrix() {
    }

    public FunctionMatrix(int rows, int cols, IntIntToDoubleFunction getFunc, IntIntDoubleToVoidFunction setFunc) {
        assert (rows > 0);
        assert (cols > 0);
        assert (getFunc != null);
        this.setStorage(new FunctionMatrixStorage(rows, cols, getFunc, setFunc));
    }

    public FunctionMatrix(int rows, int cols, IntIntToDoubleFunction getFunc) {
        assert (rows > 0);
        assert (cols > 0);
        assert (getFunc != null);
        this.setStorage(new FunctionMatrixStorage(rows, cols, getFunc));
    }

    private FunctionMatrixStorage storage() {
        return (FunctionMatrixStorage)this.getStorage();
    }

    @Override
    public Matrix copy() {
        FunctionMatrixStorage sto = this.storage();
        return new FunctionMatrix(sto.rowSize(), sto.columnSize(), sto.getFunction(), sto.setFunction());
    }

    @Override
    public Matrix like(int rows, int cols) {
        FunctionMatrixStorage sto = this.storage();
        return new FunctionMatrix(rows, cols, sto.getFunction(), sto.setFunction());
    }

    @Override
    public Vector likeVector(int crd) {
        throw new UnsupportedOperationException();
    }
}

