/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.DiagonalMatrixStorage;
import org.apache.ignite.ml.math.impls.vector.ConstantVector;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOnHeapVector;
import org.apache.ignite.ml.math.impls.vector.SingleElementVectorView;

public class DiagonalMatrix
extends AbstractMatrix {
    public DiagonalMatrix() {
    }

    public DiagonalMatrix(Vector diagonal) {
        super(new DiagonalMatrixStorage(diagonal));
    }

    public DiagonalMatrix(Matrix mtx) {
        super(new DiagonalMatrixStorage(mtx == null ? null : mtx.viewDiagonal()));
    }

    public DiagonalMatrix(double[] vals) {
        super(new DiagonalMatrixStorage(new DenseLocalOnHeapVector(vals)));
    }

    private DiagonalMatrixStorage storage() {
        return (DiagonalMatrixStorage)this.getStorage();
    }

    public DiagonalMatrix(int size, double val) {
        super(new DiagonalMatrixStorage(new ConstantVector(size, val)));
    }

    @Override
    public Vector viewRow(int row) {
        return new SingleElementVectorView(this.storage().diagonal(), row);
    }

    @Override
    public Vector viewColumn(int col) {
        return new SingleElementVectorView(this.storage().diagonal(), col);
    }

    @Override
    public Matrix copy() {
        return new DiagonalMatrix(this.storage().diagonal());
    }

    @Override
    public Matrix like(int rows, int cols) {
        return this.storage().diagonal().likeMatrix(rows, cols);
    }

    @Override
    public Vector likeVector(int crd) {
        return this.storage().diagonal().like(crd);
    }
}

