/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.OrderedMatrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.ArrayMatrixStorage;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOnHeapVector;

public class DenseLocalOnHeapMatrix
extends AbstractMatrix
implements OrderedMatrix {
    public DenseLocalOnHeapMatrix() {
    }

    public DenseLocalOnHeapMatrix(int rows, int cols) {
        this(rows, cols, 2001);
    }

    public DenseLocalOnHeapMatrix(int rows, int cols, int acsMode) {
        assert (rows > 0);
        assert (cols > 0);
        this.setStorage(new ArrayMatrixStorage(rows, cols, acsMode));
    }

    public DenseLocalOnHeapMatrix(double[][] mtx, int acsMode) {
        assert (mtx != null);
        this.setStorage(new ArrayMatrixStorage(mtx, acsMode));
    }

    public DenseLocalOnHeapMatrix(double[][] mtx) {
        this(mtx, 2001);
    }

    public DenseLocalOnHeapMatrix(double[] mtx, int rows, int acsMode) {
        assert (mtx != null);
        this.setStorage(new ArrayMatrixStorage(mtx, rows, acsMode));
    }

    public DenseLocalOnHeapMatrix(double[] mtx, int rows) {
        this(mtx, 2001, rows);
    }

    private DenseLocalOnHeapMatrix(DenseLocalOnHeapMatrix orig) {
        this(orig, orig.accessMode());
    }

    private DenseLocalOnHeapMatrix(DenseLocalOnHeapMatrix orig, int acsMode) {
        assert (orig != null);
        this.setStorage(new ArrayMatrixStorage(orig.rowSize(), orig.columnSize(), acsMode));
        this.assign(orig);
    }

    @Override
    public Matrix copy() {
        return new DenseLocalOnHeapMatrix(this, this.accessMode());
    }

    @Override
    public Matrix like(int rows, int cols) {
        return new DenseLocalOnHeapMatrix(rows, cols, this.getStorage() != null ? this.accessMode() : 2001);
    }

    @Override
    public Vector likeVector(int crd) {
        return new DenseLocalOnHeapVector(crd);
    }

    @Override
    public int accessMode() {
        return this.getStorage().accessMode();
    }
}

