/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.exceptions;

import org.apache.ignite.ml.math.exceptions.MathIllegalNumberException;

public class NumberIsTooSmallException
extends MathIllegalNumberException {
    private static final String NUMBER_TOO_SMALL = "Number {1} is smaller than the minimum ({2}).";
    private static final String NUMBER_TOO_SMALL_BOUND_EXCLUDED = "Number {1} is smaller than, or equal to, the minimum ({2}).";
    private static final long serialVersionUID = -6100997100383932834L;
    private final Number min;
    private final boolean boundIsAllowed;

    public NumberIsTooSmallException(Number wrong, Number min, boolean boundIsAllowed) {
        this(boundIsAllowed ? NUMBER_TOO_SMALL : NUMBER_TOO_SMALL_BOUND_EXCLUDED, wrong, min, boundIsAllowed);
    }

    public NumberIsTooSmallException(String msg, Number wrong, Number min, boolean boundIsAllowed) {
        super(msg, wrong, min);
        this.min = min;
        this.boundIsAllowed = boundIsAllowed;
    }

    public boolean getBoundIsAllowed() {
        return this.boundIsAllowed;
    }

    public Number getMin() {
        return this.min;
    }
}

